﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/applet/applet_Types.h>

//-----------------------------------------------------------------------------
// このヘッダに記載の関数は、nn::oe や nn::ae に公開 API を実装する時に必要
// となる内部関数を定義したものであり、このヘッダファイル自身は非公開です。
// 上記の公開 API を開発する SDK 開発者のみが利用することができます。
//-----------------------------------------------------------------------------

namespace nn { namespace applet {

/**
    @brief  自アプレットにおける無線の優先モード種別を表す列挙型です。
*/
enum WirelessPriorityMode
{
    WirelessPriorityMode_None = 0,                  //!< 無線の優先モードを指定しない
    WirelessPriorityMode_OptimizedForBluetooth = 1, //!< 無線の優先モードを Bluetooth 優先にする
    WirelessPriorityMode_OptimizedForWlan = 2,      //!< 無線の優先モードを WLAN 優先にする
};


//! @name   内部実装用関数定義
//! @{

/**
    @brief  無線の優先モードを指定する

    @param[in] mode    無線の優先モードを WirelessPriorityMode 列挙型で指定する

    @details
     自アプレットにおける無線の優先モード種別を mode で指定します。

     システムは動作中の各アプレットの無線の優先モードを個別に管理しており、
     最も上位の Foreground で動作しているアプレットのモード種別に従って、
     無線モジュールに対して 各々の優先モード変更を要求します。

     WirelessPriorityMode_None が指定されているアプレットは、
     無線の優先モードの指定を行なわず、自分より下位で動作している
     アプレットで指定されたモード種別にその指定を委ねます。

     アプリケーション および システムアプレット で、
     WirelessPriorityMode_None が指定された場合は、
     システムで規定されているデフォルトの動作モードとなります。

     各アプレットのデフォルトは以下の通りです。

     - アプリケーションは WirelessPriorityMode_OptimizedForBluetooth です。
     - システムアプレットは WirelessPriorityMode_OptimizedForBluetooth です。
     - ライブラリアプレットは WirelessPriorityMode_None です。
     - オーバーレイアプレットは WirelessPriorityMode_None です。

*/
void SetWirelessPriorityMode(WirelessPriorityMode mode) NN_NOEXCEPT;

//! @}

}} // namespace nn::applet

