﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief APM ライブラリの初期化に関係する API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace apm {

/**
 * @brief APM ライブラリを初期化します。
 *
 * @return      初期化の結果を返します。
 *
 * @post        ライブラリは初期化済の状態になります。
 * @details     APM ライブラリを初期化します。@n
 *              本関数の呼び出し回数はライブラリ内部でカウントされます。
 */
Result Initialize() NN_NOEXCEPT;

/**
 * @brief APM ライブラリを終了します。
 *
 * @post        ライブラリは初期化前の状態になります。
 * @details     APM ライブラリを終了します。@n
 *              ライブラリ初期化を行った回数分、本関数が呼ばれた場合にのみ、
 *              ライブラリが初期化前の状態になります。
 */
void Finalize() NN_NOEXCEPT;

}} // namepsace nn::apm
