﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/apm/apm_SystemTypes.h>
#include <nn/apm/apm_Types.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace apm { // NOLINT(whitespace/braces)

class ISystemManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestPerformanceMode, (::nn::apm::PerformanceMode performanceMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPerformanceEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutNativeHandle, ::nn::apm::EventTarget eventTarget))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetThrottlingState, (::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLastThrottlingState, (::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearLastThrottlingState)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(LoadAndApplySettings)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemManager)

        ::nn::Result RequestPerformanceMode(::nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestPerformanceMode, (performanceMode));
        }

        ::nn::Result GetPerformanceEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutNativeHandle, ::nn::apm::EventTarget eventTarget) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPerformanceEvent, (pOutNativeHandle, eventTarget));
        }

        ::nn::Result GetThrottlingState(::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetThrottlingState, (pOutThrottlingState));
        }

        ::nn::Result GetLastThrottlingState(::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLastThrottlingState, (pOutThrottlingState));
        }

        ::nn::Result ClearLastThrottlingState() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearLastThrottlingState);
        }

        ::nn::Result LoadAndApplySettings() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(LoadAndApplySettings);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemManager
    {
    public:
        nn::Result RequestPerformanceMode(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT;
        nn::Result GetPerformanceEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle, nn::apm::EventTarget eventTarget) NN_NOEXCEPT;
        nn::Result GetThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT;
        nn::Result GetLastThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT;
        nn::Result ClearLastThrottlingState() NN_NOEXCEPT;
        nn::Result LoadAndApplySettings() NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RequestPerformanceMode(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT;
    nn::Result GetPerformanceEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle, nn::apm::EventTarget eventTarget) NN_NOEXCEPT;
    nn::Result GetThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT;
    nn::Result GetLastThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT;
    nn::Result ClearLastThrottlingState() NN_NOEXCEPT;
    nn::Result LoadAndApplySettings() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::apm::ISystemManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPerformanceMode, (::nn::apm::PerformanceMode performanceMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestPerformanceMode, (performanceMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPerformanceEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutNativeHandle, ::nn::apm::EventTarget eventTarget))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPerformanceEvent, (pOutNativeHandle, eventTarget));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetThrottlingState, (::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetThrottlingState, (pOutThrottlingState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastThrottlingState, (::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLastThrottlingState, (pOutThrottlingState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearLastThrottlingState)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearLastThrottlingState);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(LoadAndApplySettings)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(LoadAndApplySettings);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::apm::ISystemManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::apm::ISystemManager))

    // nn::Result RequestPerformanceMode(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestPerformanceMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(performanceMode, (::nn::apm::PerformanceMode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (performanceMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(performanceMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestPerformanceMode)

    // nn::Result GetPerformanceEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle, nn::apm::EventTarget eventTarget) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPerformanceEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutNativeHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutNativeHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventTarget, (::nn::apm::EventTarget), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eventTarget))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutNativeHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventTarget)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPerformanceEvent)

    // nn::Result GetThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetThrottlingState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutThrottlingState, (::nn::apm::ThrottlingState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutThrottlingState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutThrottlingState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetThrottlingState)

    // nn::Result GetLastThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastThrottlingState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutThrottlingState, (::nn::apm::ThrottlingState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutThrottlingState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutThrottlingState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastThrottlingState)

    // nn::Result ClearLastThrottlingState() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearLastThrottlingState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearLastThrottlingState)

    // nn::Result LoadAndApplySettings() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadAndApplySettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadAndApplySettings)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::apm::PerformanceMode), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::apm::EventTarget), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::apm::ThrottlingState), 40, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::apm::ISystemManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::apm::ISystemManager))

    // nn::Result RequestPerformanceMode(nn::apm::PerformanceMode performanceMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPerformanceMode, (::nn::apm::PerformanceMode performanceMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestPerformanceMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(performanceMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestPerformanceMode)
    }

    // nn::Result GetPerformanceEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle, nn::apm::EventTarget eventTarget) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPerformanceEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutNativeHandle, ::nn::apm::EventTarget eventTarget))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPerformanceEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutNativeHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventTarget)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPerformanceEvent)
    }

    // nn::Result GetThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetThrottlingState, (::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetThrottlingState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutThrottlingState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetThrottlingState)
    }

    // nn::Result GetLastThrottlingState(nn::sf::Out<nn::apm::ThrottlingState> pOutThrottlingState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastThrottlingState, (::nn::sf::Out<::nn::apm::ThrottlingState> pOutThrottlingState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastThrottlingState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutThrottlingState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastThrottlingState)
    }

    // nn::Result ClearLastThrottlingState() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearLastThrottlingState)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearLastThrottlingState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearLastThrottlingState)
    }

    // nn::Result LoadAndApplySettings() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(LoadAndApplySettings)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadAndApplySettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadAndApplySettings)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::apm::ISystemManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::apm::ISystemManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestPerformanceMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestPerformanceMode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(performanceMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPerformanceEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutNativeHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPerformanceEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutNativeHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventTarget)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetThrottlingState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastThrottlingState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearLastThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearLastThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadAndApplySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadAndApplySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestPerformanceMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPerformanceEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearLastThrottlingState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadAndApplySettings)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::apm::ISystemManager))
