﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/am/service/window/am_WindowControllerBase.h>

#include<nn/util/util_Exchange.h>
#include <nn/nn_SdkLog.h>

namespace nn { namespace am { namespace service { namespace window {

struct SpsmEventWindowController
     : public WindowControllerBase<SpsmEventWindowController>
{

    // Status という名前でデータ構造を定義
    struct Status
    {
        bool handlesSleepRequiredByHighTemperature;
        bool handlesSleepRequiredByLowBattery;
        bool handlesAutoPowerDown;
    };

    // active でないときの Status を初期化する関数
    static void SetNotActive(Status* p) NN_NOEXCEPT
    {
        p->handlesSleepRequiredByHighTemperature = false;
        p->handlesSleepRequiredByLowBattery = false;
        p->handlesAutoPowerDown = false;
    }

    // これが true を返す場合は Update 系関数は呼ばれない
    static bool AreEqual(const Status& x, const Status& y) NN_NOEXCEPT
    {
        return true
            && x.handlesSleepRequiredByHighTemperature == y.handlesSleepRequiredByHighTemperature
            && x.handlesSleepRequiredByLowBattery == y.handlesSleepRequiredByLowBattery
            && x.handlesAutoPowerDown == y.handlesAutoPowerDown;
    }

    struct Property
    {
        bool handlesSleepRequiredByHighTemperature;
        bool handlesSleepRequiredByLowBattery;
        bool handlesAutoPowerDown;
    };

    void CalculateStatus(Status* pOut, const CommonWindowProperty& commonProp, const Property& prop, CalculationContext* pContext) NN_NOEXCEPT
    {
        NN_UNUSED( commonProp );
        NN_UNUSED( pContext );
        pOut->handlesSleepRequiredByHighTemperature = prop.handlesSleepRequiredByHighTemperature;
        pOut->handlesSleepRequiredByLowBattery = prop.handlesSleepRequiredByLowBattery;
        pOut->handlesAutoPowerDown = prop.handlesAutoPowerDown;
    }

    // 必要なものを定義(不要なものはコメントアウトすること)
    //static void UpdateNegativeImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    //static void UpdateNegative(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    static void UpdateImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    //static void UpdatePositive(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;
    //static void UpdatePositiveImmediately(Window* p, const Status& oldStatus, const Status& newStatus) NN_NOEXCEPT;

    typedef Status EventStatus;

    struct EventType
    {
        bool onSleepRequiredByHighTemperature;
        bool onSleepRequiredByLowBattery;
        bool onAutoPowerDown;
    };

    void HandleEvent(Window* p, const EventStatus& eventStatus, const EventType& e) NN_NOEXCEPT;

};

}}}}
