﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "am_IntegratedDisplayLayer.h"
#include "am_DirectLayerVisibilityManager.h"
#include "am_IntegratedDisplayLayerHandle.h"

namespace nn{ namespace am{ namespace service{ namespace display{ namespace detail{

    class IntegratedDisplayLayerPool
    {
    public:
        static const int LayerCount = 16;

    public:

        // 有効な未使用のレイヤを取得する。
        // 取得できなかった場合無効なハンドルを返す。
        IntegratedDisplayLayerHandle Acquire() NN_NOEXCEPT;

        // レイヤを解放する。
        // @pre h は有効な未初期化レイヤのハンドル。
        void Release(IntegratedDisplayLayerHandle h) NN_NOEXCEPT;

        // ハンドルからレイヤを取得する。
        // h が無効な場合 nullptr を返す。
        IntegratedDisplayLayer* GetLayer(IntegratedDisplayLayerHandle h) NN_NOEXCEPT;
        const IntegratedDisplayLayer* GetLayer(IntegratedDisplayLayerHandle h) const NN_NOEXCEPT;

        // インデックス指定でレイヤを取得する。
        // 指定したインデックスが [0, LayerCount) の範囲外である、またはレイヤが未使用の場合 nullptr を返す。
        const IntegratedDisplayLayer* GetLayerAt(int index) const NN_NOEXCEPT;

        // ハンドルから VisibilityManager を取得する。
        DirectLayerVisibilityManager* GetVisibilityManager(IntegratedDisplayLayerHandle h) NN_NOEXCEPT;

        DirectLayerVisibilityManager* GetVisibilityManagerAt(int index) NN_NOEXCEPT;

    private:
        // 有効なハンドルならインデックスを返す。無効なら -1。
        int GetLayerIndexImpl(IntegratedDisplayLayerHandle h) const NN_NOEXCEPT;

    private:
        struct
        {
            IntegratedDisplayLayer m_Layer;
            DirectLayerVisibilityManager m_VisibilityManager;
        } m_List[LayerCount] = {};

    };

}}}}}
