﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_SystemContentMetaId.h>

//
// ここにある ProgramId の定数は以下のソースからも参照されています。
// ProgramId の定義を追加する場合は DevMenuCommand の applet コマンドも
// 同時に対応して下さい。
//
// - Programs/Eris/Sources/TargetTools/DevMenuCommand/DevMenuCommand_AppletCommand.cpp
//

namespace nn { namespace am { namespace service {

const ncm::SystemProgramId ProgramId_LibraryAppletAuth         = { 0x0100000000001001 }; // 簡易認証 LA
const ncm::SystemProgramId ProgramId_LibraryAppletCabinet      = { 0x0100000000001002 }; // amiibo 設定 LA
const ncm::SystemProgramId ProgramId_LibraryAppletController   = { 0x0100000000001003 }; // コントローラー LA
const ncm::SystemProgramId ProgramId_LibraryAppletDataErase    = { 0x0100000000001004 }; // データ削除 LA
const ncm::SystemProgramId ProgramId_LibraryAppletError        = { 0x0100000000001005 }; // エラービューアー LA
const ncm::SystemProgramId ProgramId_LibraryAppletNetConnect   = { 0x0100000000001006 }; // ネット接続 LA
const ncm::SystemProgramId ProgramId_LibraryAppletPlayerSelect = { 0x0100000000001007 }; // プレイヤー選択 LA
const ncm::SystemProgramId ProgramId_LibraryAppletSwkbd        = { 0x0100000000001008 }; // ソフトウェアキーボード LA
const ncm::SystemProgramId ProgramId_LibraryAppletMiiEdit      = { 0x0100000000001009 }; // Mii 編集 LA
const ncm::SystemProgramId ProgramId_LibraryAppletWeb          = { 0x010000000000100A }; // Web LA
const ncm::SystemProgramId ProgramId_LibraryAppletShop         = { 0x010000000000100B }; // ショップ LA

const ncm::SystemProgramId ProgramId_LibraryAppletPhotoViewer  = { 0x010000000000100D }; // フォトビューアー LA
const ncm::SystemProgramId ProgramId_LibraryAppletSet          = { 0x010000000000100E }; // 本体設定 LA
const ncm::SystemProgramId ProgramId_LibraryAppletOfflineWeb   = { 0x010000000000100F }; // Offline Web LA
const ncm::SystemProgramId ProgramId_LibraryAppletLoginShare   = { 0x0100000000001010 }; // ログインシェア LA
const ncm::SystemProgramId ProgramId_LibraryAppletWifiWebAuth  = { 0x0100000000001011 }; // WiFi WebAuth  LA

const ncm::SystemProgramId ProgramId_LibraryAppletMyPage       = { 0x0100000000001013 }; // マイページ LA

const ncm::SystemProgramId ProgramId_SystemAppletMenu          = { 0x0100000000001000 }; // SA メニュー

const ncm::SystemProgramId ProgramId_OverlayApplet             = { 0x010000000000100C }; // オーバーレイ表示 LA

const ncm::SystemProgramId ProgramId_SystemApplication         = { 0x0100000000001012 }; // システムアプリケーション

const ncm::SystemProgramId ProgramId_MaintenanceMenu           = { 0x0100000000001015 }; // メンテナンスモード

const ncm::SystemProgramId ProgramId_LibraryAppletDummyShop    = { 0x010000000000101B }; // Dummy Shop LA

const ncm::SystemProgramId ProgramId_LibraryAppletGift         = { 0x010000000000101A }; // おすそわけ通信 LA

const ncm::SystemProgramId ProgramId_LibraryAppletUserMigration = { 0x010000000000101C }; // ユーザ移行 LA

const ncm::SystemProgramId ProgramId_LibraryAppletEncounter    = { 0x010000000000101D }; // すれちがい LA

const ncm::SystemProgramId ProgramId_LibraryAppletStory        = { 0x0100000000001020 }; // セーブデータ同期 LA

}}} // namespace nn::am::service
