﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/am/service/am_Monitoring.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/am/service/am_StuckCheckKind.h>
#include <memory>

namespace nn { namespace os {
    struct ThreadType;
}}

namespace nn { namespace am { namespace service {
namespace detail {

class StuckMonitorThreadInfo;

class StuckMonitorHandler final
    : public MonitorHandler
    , public util::IntrusiveListBaseNode<StuckMonitorHandler>
{
    friend StuckMonitorThreadInfo;
public:
    explicit StuckMonitorHandler(int32_t kind, const char* text) NN_NOEXCEPT;
    ~StuckMonitorHandler() NN_NOEXCEPT;
private:
    const int32_t m_Kind;
    const char* const m_Text;
    StuckMonitorThreadInfo* const m_pThreadInfo;
    const uint64_t m_SequenceNumber;
    virtual void OnExpired() NN_NOEXCEPT NN_OVERRIDE;
};

class ScopedStuckMonitorHandler
{
public:
    ScopedStuckMonitorHandler(int kind, TimeSpan expireTime, const char* text) NN_NOEXCEPT;
    ScopedStuckMonitorHandler(int kind, int seconds, const char* text) NN_NOEXCEPT
        : ScopedStuckMonitorHandler(kind, TimeSpan::FromSeconds(seconds), text)
    {
    }
    ~ScopedStuckMonitorHandler() NN_NOEXCEPT;
private:
    StuckMonitorHandler m_Handler;
    MonitorHolder* m_pHolder;
};

}

}}}

#if defined(NN_SDK_BUILD_RELEASE) && NN_SDK_BUILD_RELEASE
    #define NN_AM_SERVICE_GET_STUCK_KIND_STRING(kind) nullptr
#else
    #define NN_AM_SERVICE_GET_STUCK_KIND_STRING(kind) NN_MACRO_STRINGIZE(kind)
#endif

#define NN_AM_SERVICE_STUCK_CHECKED(kind, expireTime, exp) \
    (::nn::am::service::detail::ScopedStuckMonitorHandler(NN_AM_SERVICE_DETAIL_GET_STUCK_CHECK_KIND(kind), expireTime, NN_AM_SERVICE_GET_STUCK_KIND_STRING(kind)), exp)

#define NN_AM_SERVICE_SCOPED_STUCK_CHECK(kind, expireTime) \
    ::nn::am::service::detail::ScopedStuckMonitorHandler NN_MAKE_TEMPORARY_NAME(_nn_am_service_scoped_stuck_check) (NN_AM_SERVICE_DETAIL_GET_STUCK_CHECK_KIND(kind), expireTime, NN_AM_SERVICE_GET_STUCK_KIND_STRING(kind));
