﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/os/os_ThreadApi.h>
#include <nn/am/am_ResultPrivate.h>

#define NN_AM_SERVICE_DIAGNOSTICS_ENABLED 1 // NOLINT(preprocessor/const)
#define NN_AM_SERVICE_DIAGNOSTICS_LOG_ENABLED 1 // NOLINT(preprocessor/const)

#define NN_AM_SERVICE_DIAGNOSTICS_SET_CONTEXT_NAME(name) ::nn::os::SetThreadNamePointer(::nn::os::GetCurrentThread(), NN_SYSTEM_THREAD_NAME(am, name))
#define NN_AM_SERVICE_NOT_IMPLEMENTED(...) NN_AM_SERVICE_LOG(error, __VA_ARGS__); return ::nn::am::ResultNotImplemented();

#define NN_AM_SERVICE_DIAGNOSTICS_LOG_FORCE(inSeverity, ...) \
    do \
    { \
        ::nn::diag::LogMetaData logMetaData = {}; \
        logMetaData.sourceInfo.lineNumber = __LINE__; \
        logMetaData.sourceInfo.fileName = __FILE__; \
        logMetaData.sourceInfo.functionName = NN_CURRENT_FUNCTION_NAME; \
        logMetaData.moduleName = "$am"; \
        logMetaData.severity = ::nn::diag::LogSeverity_##inSeverity; \
        ::nn::diag::detail::LogImpl(logMetaData, __VA_ARGS__); \
    } while (NN_STATIC_CONDITION(0))

#define NN_AM_SERVICE_LOG_PREFIX "AM: "

#if !NN_AM_SERVICE_DIAGNOSTICS_LOG_ENABLED
    #define NN_AM_SERVICE_LOG(...) static_cast<void>(0)
    #define NN_AM_SERVICE_LOG_CHECKPOINT static_cast<void>(0)
#else // NN_AM_SERVICE_DIAGNOSTICS_LOG_ENABLED
    #include <nn/nn_SdkLog.h>
    #include <nn/am/detail/am_Log.h>
    #define NN_AM_SERVICE_LOG(kind, ...) NN_AM_SERVICE_LOG_##kind(__VA_ARGS__)
    #define NN_AM_SERVICE_LOG_error(...) NN_DETAIL_AM_ERROR(NN_AM_SERVICE_LOG_PREFIX "ERROR: " __VA_ARGS__)
    #define NN_AM_SERVICE_LOG_dev(...) //NN_DETAIL_AM_WARN("DEV: " __VA_ARGS__)
    #define NN_AM_SERVICE_LOG_seq(...) //NN_DETAIL_AM_INFO("TRACE: " __VA_ARGS__)
    #define NN_AM_SERVICE_LOG_call(...) //NN_DETAIL_AM_TRACE("TRACE: " __VA_ARGS__)
    #define NN_AM_SERVICE_LOG_event(...) //NN_DETAIL_AM_INFO_V3("EVENT: " __VA_ARGS__)
    #define NN_AM_SERVICE_LOG_force(...) NN_AM_SERVICE_DIAGNOSTICS_LOG_FORCE(Warn, "DEBUG: " __VA_ARGS__)
    #define NN_AM_SERVICE_LOG_CHECKPOINT NN_AM_SERVICE_DIAGNOSTICS_LOG_FORCE(Fatal, "% 4d %s\n", __LINE__, __FILE__)
#endif // NN_AM_SERVICE_DIAGNOSTICS_LOG_ENABLED

#if !NN_AM_SERVICE_DIAGNOSTICS_ENABLED

namespace nn { namespace am { namespace service { namespace diagnostics {

class AppletBase {};
#define NN_AM_SERVICE_DIAGNOSTICS_DEFINE_APPLET_KIND_STRING(name)
#define NN_AM_SERVICE_APPLET_LOG(pApplet, format, ...) static_cast<void>(pApplet)

}}}}

#else // NN_AM_SERVICE_DIAGNOSTICS_ENABLED

#define NN_AM_SERVICE_DIAGNOSTICS_RESULT_STRING_FORMAT "result(%08x)"
#define NN_AM_SERVICE_DIAGNOSTICS_RESULT_STRING_FORMAT_PARAMETER(r) ((r).GetInnerValueForDebug())

#define NN_AM_SERVICE_DIAGNOSTICS_THREAD_STRING_FORMAT "thread(%p)"
#define NN_AM_SERVICE_DIAGNOSTICS_THREAD_STRING_FORMAT_PARAMETER(pThread) (pThread)

#define NN_AM_SERVICE_DIAGNOSTICS_PROCESS_ID_STRING_FORMAT "process(%llu)"
#define NN_AM_SERVICE_DIAGNOSTICS_PROCESS_ID_STRING_FORMAT_PARAMETER(pid) ((pid).value)

#include <nn/nn_Common.h>
#include <atomic>

namespace nn { namespace am { namespace service { namespace diagnostics {

template <typename Tag>
class SerialNumber
{
public:

    SerialNumber() NN_NOEXCEPT
        : m_SerialNumber(++g_Current)
    {
    }

    int GetSerialNumber() const NN_NOEXCEPT
    {
        return m_SerialNumber;
    }

private:

    static std::atomic<int> g_Current;
    int m_SerialNumber;

};

template <typename Tag>
std::atomic<int> SerialNumber<Tag>::g_Current;

class AppletBase
    : public SerialNumber<AppletBase>
{
protected:

    AppletBase() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(seq, "(unknown)[%d]: construct\n", this->GetSerialNumber());
    }

    ~AppletBase() NN_NOEXCEPT
    {
        NN_AM_SERVICE_LOG(seq, "(unknown)[%d]: destruct\n", this->GetSerialNumber());
    }

public:

    virtual const char* GetAppletKindString() const NN_NOEXCEPT
    {
        return "(unknown)";
    }

};

#define NN_AM_SERVICE_DIAGNOSTICS_DEFINE_APPLET_KIND_STRING(name) \
    virtual const char* GetAppletKindString() const NN_NOEXCEPT NN_OVERRIDE \
    { \
        return name; \
    }

#define NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT "%s[%d]"
#define NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT_PARAMETER(pApplet) (pApplet)->GetAppletKindString(), (pApplet)->GetSerialNumber()

#define NN_AM_SERVICE_APPLET_LOG_IMPL(kind, pApplet, format, ...) \
    NN_AM_SERVICE_LOG(kind, NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT "%s: " format "\n", NN_AM_SERVICE_DIAGNOSTICS_APPLET_STRING_FORMAT_PARAMETER(pApplet), __VA_ARGS__)

#define NN_AM_SERVICE_APPLET_LOG(kind, pApplet, format, ...) \
    NN_AM_SERVICE_APPLET_LOG_IMPL(kind, pApplet, format, "", ##__VA_ARGS__)

}}}}

#endif // NN_AM_SERVICE_DIAGNOSTICS_ENABLED
