﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/am/service/am_IntegratedApplet.h>
#include <nn/arp/arp_Types.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/err/err_Types.h>
#include <nn/hid/system/hid_PlayReport.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>

namespace nn { namespace am { namespace service {

struct ApplicationErrorReportInfo
{
    const ns::ApplicationControlProperty& controlProperty;
    const ns::ApplicationLaunchInfo& launchProperty;
};

Result MakeApplicationAbortErrorReport(Result result, const ApplicationErrorReportInfo& info) NN_NOEXCEPT;
Result MakeCreateProcessFailureErrorReport(Result result, Bit64 id) NN_NOEXCEPT;
Result MakeVisibleErrorReport(err::ErrorCode errorCode, am::service::IntegratedApplet* pCallerApplet) NN_NOEXCEPT;
Result MakeVisibleErrorReport(err::ErrorCode errorCode, const err::ErrorContext& errorContext, am::service::IntegratedApplet* pCallerApplet) NN_NOEXCEPT;
Result MakeMultimediaErrorReportIfNecessary(Bit32 resultValue, am::service::IntegratedApplet* pCallerApplet, const char* pMultiMediaTelemetry, size_t multimediaTelemetrySize) NN_NOEXCEPT;

void RegisterRunningApplication(const ApplicationErrorReportInfo& info) NN_NOEXCEPT;
void UnregisterRunningApplication() NN_NOEXCEPT;

void RegisterRunningApplet(ncm::ProgramId id) NN_NOEXCEPT;
void UnregisterRunningApplet(ncm::ProgramId id) NN_NOEXCEPT;

void UpdateFocusedAppletHistory(ncm::ProgramId id) NN_NOEXCEPT;

Result SubmitApplicationInfo(const ApplicationErrorReportInfo& info) NN_NOEXCEPT;
Result SubmitApplicationInfo(Bit64 idValue) NN_NOEXCEPT;

void UpdateErrorReportControllerUsage() NN_NOEXCEPT;

}}}
