﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ahid/sfdl/ICtrlSession.sfdl.h>
#include <nn/ahid/sfdl/IReadSession.sfdl.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ahid { // NOLINT(whitespace/braces)

class IServerSession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IServerSession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IServerSession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireDevice, (::std::uint32_t deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseDevice, (::std::uint32_t deviceHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlSession, (::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::ICtrlSession>> outCtrlSession))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReadSession, (::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::IReadSession>> outReadSession))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IServerSession)

        ::nn::Result AcquireDevice(::std::uint32_t deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireDevice, (deviceHandle));
        }

        ::nn::Result ReleaseDevice(::std::uint32_t deviceHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReleaseDevice, (deviceHandle));
        }

        ::nn::Result GetCtrlSession(::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCtrlSession, (deviceHandle, outCtrlSession));
        }

        ::nn::Result GetReadSession(::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReadSession, (deviceHandle, outReadSession));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IServerSession
    {
    public:
        nn::Result AcquireDevice(std::uint32_t deviceHandle) NN_NOEXCEPT;
        nn::Result ReleaseDevice(std::uint32_t deviceHandle) NN_NOEXCEPT;
        nn::Result GetCtrlSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT;
        nn::Result GetReadSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result AcquireDevice(std::uint32_t deviceHandle) NN_NOEXCEPT;
    nn::Result ReleaseDevice(std::uint32_t deviceHandle) NN_NOEXCEPT;
    nn::Result GetCtrlSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT;
    nn::Result GetReadSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ahid::IServerSession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireDevice, (::std::uint32_t deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireDevice, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseDevice, (::std::uint32_t deviceHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReleaseDevice, (deviceHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlSession, (::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::ICtrlSession>> outCtrlSession))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCtrlSession, (deviceHandle, outCtrlSession));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadSession, (::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::IReadSession>> outReadSession))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReadSession, (deviceHandle, outReadSession));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ahid::IServerSession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ahid::IServerSession))

    // nn::Result AcquireDevice(std::uint32_t deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireDevice)

    // nn::Result ReleaseDevice(std::uint32_t deviceHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleaseDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleaseDevice)

    // nn::Result GetCtrlSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCtrlSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outCtrlSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outCtrlSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCtrlSession)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCtrlSession)

    // nn::Result GetReadSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReadSession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outReadSession, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outReadSession))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(deviceHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (deviceHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadSession)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReadSession)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ahid::IServerSession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ahid::IServerSession))

    // nn::Result AcquireDevice(std::uint32_t deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireDevice, (::std::uint32_t deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireDevice)
    }

    // nn::Result ReleaseDevice(std::uint32_t deviceHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseDevice, (::std::uint32_t deviceHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleaseDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleaseDevice)
    }

    // nn::Result GetCtrlSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCtrlSession, (::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::ICtrlSession>> outCtrlSession))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCtrlSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCtrlSession)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCtrlSession)
    }

    // nn::Result GetReadSession(std::uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadSession, (::std::uint32_t deviceHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ahid::IReadSession>> outReadSession))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReadSession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadSession)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReadSession)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ahid::IServerSession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ahid::IServerSession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleaseDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleaseDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCtrlSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ahid::ICtrlSession>), outCtrlSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCtrlSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outCtrlSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outCtrlSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReadSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ahid::IReadSession>), outReadSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReadSession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(deviceHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outReadSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outReadSession, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleaseDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCtrlSession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReadSession)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ahid::IServerSession))
