﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ahid/hdr/hdr_Types.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ahid { namespace hdr { // NOLINT(whitespace/braces)

class ISession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceEntries, (::nn::sf::Out<::std::uint32_t> pEntries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceList, (::nn::sf::Out<::std::uint32_t> pOutEntries, ::std::uint32_t entries, const ::nn::sf::OutBuffer& outDeviceHandles, const ::nn::sf::InBuffer& inAttachFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceParameters, (::nn::ahid::hdr::DeviceHandle handle, const ::nn::sf::OutBuffer& outDeviceParameters))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AttachDevice, (const ::nn::sf::InBuffer& inDeviceParameters, ::nn::sf::Out<::nn::ahid::hdr::DeviceHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DetachDevice, (::nn::ahid::hdr::DeviceHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceFilterForHipc, (const ::nn::sf::InBuffer& inDeviceFilter, ::std::uint32_t entries))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISession)

        ::nn::Result GetDeviceEntries(::nn::sf::Out<::std::uint32_t> pEntries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceEntries, (pEntries));
        }

        ::nn::Result GetDeviceList(::nn::sf::Out<::std::uint32_t> pOutEntries, ::std::uint32_t entries, const ::nn::sf::OutBuffer& outDeviceHandles, const ::nn::sf::InBuffer& inAttachFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceList, (pOutEntries, entries, outDeviceHandles, inAttachFilter));
        }

        ::nn::Result GetDeviceParameters(::nn::ahid::hdr::DeviceHandle handle, const ::nn::sf::OutBuffer& outDeviceParameters) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceParameters, (handle, outDeviceParameters));
        }

        ::nn::Result AttachDevice(const ::nn::sf::InBuffer& inDeviceParameters, ::nn::sf::Out<::nn::ahid::hdr::DeviceHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AttachDevice, (inDeviceParameters, outHandle));
        }

        ::nn::Result DetachDevice(::nn::ahid::hdr::DeviceHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DetachDevice, (handle));
        }

        ::nn::Result SetDeviceFilterForHipc(const ::nn::sf::InBuffer& inDeviceFilter, ::std::uint32_t entries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDeviceFilterForHipc, (inDeviceFilter, entries));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISession
    {
    public:
        nn::Result GetDeviceEntries(nn::sf::Out<std::uint32_t> pEntries) NN_NOEXCEPT;
        nn::Result GetDeviceList(nn::sf::Out<std::uint32_t> pOutEntries, std::uint32_t entries, const nn::sf::OutBuffer& outDeviceHandles, const nn::sf::InBuffer& inAttachFilter) NN_NOEXCEPT;
        nn::Result GetDeviceParameters(nn::ahid::hdr::DeviceHandle handle, const nn::sf::OutBuffer& outDeviceParameters) NN_NOEXCEPT;
        nn::Result AttachDevice(const nn::sf::InBuffer& inDeviceParameters, nn::sf::Out<nn::ahid::hdr::DeviceHandle> outHandle) NN_NOEXCEPT;
        nn::Result DetachDevice(nn::ahid::hdr::DeviceHandle handle) NN_NOEXCEPT;
        nn::Result SetDeviceFilterForHipc(const nn::sf::InBuffer& inDeviceFilter, std::uint32_t entries) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDeviceEntries(nn::sf::Out<std::uint32_t> pEntries) NN_NOEXCEPT;
    nn::Result GetDeviceList(nn::sf::Out<std::uint32_t> pOutEntries, std::uint32_t entries, const nn::sf::OutBuffer& outDeviceHandles, const nn::sf::InBuffer& inAttachFilter) NN_NOEXCEPT;
    nn::Result GetDeviceParameters(nn::ahid::hdr::DeviceHandle handle, const nn::sf::OutBuffer& outDeviceParameters) NN_NOEXCEPT;
    nn::Result AttachDevice(const nn::sf::InBuffer& inDeviceParameters, nn::sf::Out<nn::ahid::hdr::DeviceHandle> outHandle) NN_NOEXCEPT;
    nn::Result DetachDevice(nn::ahid::hdr::DeviceHandle handle) NN_NOEXCEPT;
    nn::Result SetDeviceFilterForHipc(const nn::sf::InBuffer& inDeviceFilter, std::uint32_t entries) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ahid::hdr::ISession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceEntries, (::nn::sf::Out<::std::uint32_t> pEntries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceEntries, (pEntries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceList, (::nn::sf::Out<::std::uint32_t> pOutEntries, ::std::uint32_t entries, const ::nn::sf::OutBuffer& outDeviceHandles, const ::nn::sf::InBuffer& inAttachFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceList, (pOutEntries, entries, outDeviceHandles, inAttachFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceParameters, (::nn::ahid::hdr::DeviceHandle handle, const ::nn::sf::OutBuffer& outDeviceParameters))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceParameters, (handle, outDeviceParameters));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachDevice, (const ::nn::sf::InBuffer& inDeviceParameters, ::nn::sf::Out<::nn::ahid::hdr::DeviceHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AttachDevice, (inDeviceParameters, outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DetachDevice, (::nn::ahid::hdr::DeviceHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DetachDevice, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceFilterForHipc, (const ::nn::sf::InBuffer& inDeviceFilter, ::std::uint32_t entries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDeviceFilterForHipc, (inDeviceFilter, entries));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ahid::hdr::ISession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ahid::hdr::ISession))

    // nn::Result GetDeviceEntries(nn::sf::Out<std::uint32_t> pEntries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceEntries)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEntries, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEntries))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEntries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceEntries)

    // nn::Result GetDeviceList(nn::sf::Out<std::uint32_t> pOutEntries, std::uint32_t entries, const nn::sf::OutBuffer& outDeviceHandles, const nn::sf::InBuffer& inAttachFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDeviceHandles, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inAttachFilter, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outDeviceHandles, inAttachFilter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entries, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (entries))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutEntries, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutEntries))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutEntries), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entries), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDeviceHandles), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAttachFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceList)

    // nn::Result GetDeviceParameters(nn::ahid::hdr::DeviceHandle handle, const nn::sf::OutBuffer& outDeviceParameters) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceParameters)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outDeviceParameters, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outDeviceParameters))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ahid::hdr::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outDeviceParameters)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceParameters)

    // nn::Result AttachDevice(const nn::sf::InBuffer& inDeviceParameters, nn::sf::Out<nn::ahid::hdr::DeviceHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AttachDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inDeviceParameters, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inDeviceParameters))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outHandle, (::nn::ahid::hdr::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inDeviceParameters), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AttachDevice)

    // nn::Result DetachDevice(nn::ahid::hdr::DeviceHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DetachDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ahid::hdr::DeviceHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DetachDevice)

    // nn::Result SetDeviceFilterForHipc(const nn::sf::InBuffer& inDeviceFilter, std::uint32_t entries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDeviceFilterForHipc)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inDeviceFilter, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inDeviceFilter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(entries, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (entries))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inDeviceFilter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(entries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDeviceFilterForHipc)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ahid::hdr::DeviceHandle), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ahid::hdr::ISession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ahid::hdr::ISession))

    // nn::Result GetDeviceEntries(nn::sf::Out<std::uint32_t> pEntries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceEntries, (::nn::sf::Out<::std::uint32_t> pEntries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceEntries)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEntries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceEntries)
    }

    // nn::Result GetDeviceList(nn::sf::Out<std::uint32_t> pOutEntries, std::uint32_t entries, const nn::sf::OutBuffer& outDeviceHandles, const nn::sf::InBuffer& inAttachFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceList, (::nn::sf::Out<::std::uint32_t> pOutEntries, ::std::uint32_t entries, const ::nn::sf::OutBuffer& outDeviceHandles, const ::nn::sf::InBuffer& inAttachFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutEntries)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entries)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDeviceHandles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAttachFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceList)
    }

    // nn::Result GetDeviceParameters(nn::ahid::hdr::DeviceHandle handle, const nn::sf::OutBuffer& outDeviceParameters) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceParameters, (::nn::ahid::hdr::DeviceHandle handle, const ::nn::sf::OutBuffer& outDeviceParameters))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outDeviceParameters)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceParameters)
    }

    // nn::Result AttachDevice(const nn::sf::InBuffer& inDeviceParameters, nn::sf::Out<nn::ahid::hdr::DeviceHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AttachDevice, (const ::nn::sf::InBuffer& inDeviceParameters, ::nn::sf::Out<::nn::ahid::hdr::DeviceHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AttachDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inDeviceParameters)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AttachDevice)
    }

    // nn::Result DetachDevice(nn::ahid::hdr::DeviceHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DetachDevice, (::nn::ahid::hdr::DeviceHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DetachDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DetachDevice)
    }

    // nn::Result SetDeviceFilterForHipc(const nn::sf::InBuffer& inDeviceFilter, std::uint32_t entries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceFilterForHipc, (const ::nn::sf::InBuffer& inDeviceFilter, ::std::uint32_t entries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDeviceFilterForHipc)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inDeviceFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(entries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDeviceFilterForHipc)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ahid::hdr::ISession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ahid::hdr::ISession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceEntries)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDeviceHandles)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAttachFilter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutEntries),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entries),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDeviceHandles),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAttachFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outDeviceParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outDeviceParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AttachDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inDeviceParameters)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AttachDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inDeviceParameters),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DetachDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DetachDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDeviceFilterForHipc)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inDeviceFilter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDeviceFilterForHipc)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inDeviceFilter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(entries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AttachDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DetachDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDeviceFilterForHipc)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ahid::hdr::ISession))
