﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace ahid {
namespace hdr {

const int AhidDescriptorTypeString  = 0x03;
const int AhidDevicesCountMax       = 32;

// busId definitions
const int AhidBusIdUnknown          = 0;
const int AhidBusIdVirtual          = 1;
const int AhidBusIdWin32            = 2;
const int AhidBusIdUsb              = 3;
const int AhidBusIdBt               = 4;

typedef uint32_t DeviceHandle;

struct DeviceParameters             //!< Device parameters used to query for specific device.
{

    uint8_t     servicePath[8];     //!< server service path
    uint32_t    deviceHandle;       //!< device handle
    uint16_t    usagePage;          //!< HID defined usage page
    uint16_t    usageId;            //!< HID defined usage id
    uint32_t    busId;              //!< device bus id
    uint32_t    vendorId;           //!< device vendor id
    uint32_t    productId;          //!< device product id
    uint32_t    versionNumber;      //!< device version number
    uint8_t     manufacturer[64];   //!< device manufacturer string
    uint8_t     product[64];        //!< device product string
    uint8_t     serialNumber[64];   //!< device serial number string
    uint32_t    pid;                //!< device allowed process id

};

struct AttachFilter                 //!< Attach filter used to filter for device attach, each item is filtered when non-zero
{

    uint16_t    usagePage;          //!< HID defined usage page
    uint16_t    usageId;            //!< HID defined usage id
    uint32_t    busId;              //!< device bus id
    uint32_t    vendorId;           //!< device vendor id
    uint32_t    productId;          //!< device product id
    uint32_t    versionNumber;      //!< device version number
    uint8_t     manufacturer[64];   //!< device manufacturer string
    uint8_t     product[64];        //!< device product string
    uint8_t     serialNumber[64];   //!< device serial number string
    uint64_t    attachedAfterTicks; //!< device attached after specified ticks

};


struct DeviceFilter                 //!< Device filter used to filter HIPC client device list, each item is filtered when non-zero
{
    uint32_t    vendorId;           //!< device vendor id
    uint32_t    productId;          //!< device product id (0x0000 can be vaid for PID)
    uint16_t    usagePage;          //!< HID defined usage page
    uint16_t    usageId;            //!< HID defined usage id
};


} // end of namespace hdr
} // end of namespace ahid
} // end of namespace nn
