﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

/**
    @file
    @brief Content Action Name に関する API の宣言
 */

namespace nn { namespace ae {

//! @name Content Action Name に関する API
//! @{

/**
    @brief 指定した Content Action Name に対応する ApplicationId を取得します。

    @param[out] pOut 出力先バッファを指定します。
    @param[in] name Content Action Name を null 終端文字列として指定します。
    @return 処理の結果を返します。
*/
Result GetApplicationIdByContentActionName(ncm::ApplicationId* pOut, const char* name) NN_NOEXCEPT;

//! @}

}}
