﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/detail/account_SharedCounter.h>
#include <nn/account/account_Types.h>

#include <utility>
#include <nn/nn_Common.h>

namespace nn { namespace account { namespace user {

class UserRegistry;

}}} // ~namespace nn::account::user

namespace nn { namespace account { namespace user {

class UserRef
{
    friend class UserRegistry;

private:
    Uid m_User;
    detail::SharedCounter m_Counter;

    UserRef(const Uid& user, detail::Counter& counter) NN_NOEXCEPT
        : m_User(user)
        , m_Counter(counter)
    {
        NN_SDK_ASSERT(m_User);
        NN_SDK_ASSERT(m_Counter);
    }
    void Swap(UserRef& rhs) NN_NOEXCEPT
    {
        std::swap(this->m_User, rhs.m_User);
        std::swap(this->m_Counter, rhs.m_Counter);
    }

public:
    UserRef() NN_NOEXCEPT
        : m_User(InvalidUid)
    {
    }
    UserRef(const UserRef& rhs) NN_NOEXCEPT
        : m_User(rhs.m_User)
        , m_Counter(rhs.m_Counter)
    {
    }
    UserRef(UserRef&& rhs) NN_NOEXCEPT
        : m_User(rhs.m_User)
        , m_Counter(std::move(rhs.m_Counter))
    {
        rhs.m_User = InvalidUid;
    }
    UserRef& operator=(const UserRef& rhs) NN_NOEXCEPT
    {
        UserRef tmp(rhs);
        tmp.Swap(*this);
        return *this;
    }
    UserRef& operator=(UserRef&& rhs) NN_NOEXCEPT
    {
        UserRef tmp(std::move(rhs));
        tmp.Swap(*this);
        return *this;
    }
    void Release() NN_NOEXCEPT
    {
        UserRef tmp;
        tmp.Swap(*this);
    }
    bool IsValid() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Counter ? m_User : true);
        return m_Counter;
    }
    NN_EXPLICIT_OPERATOR Uid() const NN_NOEXCEPT
    {
        return m_User;
    }
    uint32_t GetCount() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT(IsValid());
        return m_Counter.Get();
    }
};

}}} // ~namespace nn::account::user
