﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace account {
namespace nas {

struct NasUserBase
{
    bool isChild;
    char screenName[128];
    char email[256];
    char loginId[32];
    char nickname[64];
    char birthday[16];
    char gender[8];
    bool analyticsOptedIn;
    bool analyticsForTargetMarketingPermitted;
    bool analyticsForInternalAnalysisPermitted;
    char language[8];
    char country[4];
    char region[4];
    char timezone[64];

    bool isNnLinked;
    bool isTwitterLinked;
    bool isFacebookLinked;
    bool isGoogleLinked;
};

struct NasUserBaseForApplication
{
    char birthday[16];
    char gender[8];
    char language[8];
    char country[4];
    char region[4];
    char timezone[64];
};

} // ~namespace nn::account::nas
}
}
