﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/account/account_TypesForSystemServices.h>
#include <nn/account/detail/account_IAsyncContext.sfdl.h>
#include <nn/account/detail/account_InternalTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace account { namespace http { // NOLINT(whitespace/braces)

class IOAuthProcedure;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IOAuthProcedure, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IOAuthProcedure)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequest, (::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ApplyResponse, (const ::nn::sf::InArray<char>& response))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ApplyResponseAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::sf::InArray<char>& response))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Suspend, (::nn::sf::Out<::nn::account::detail::Uuid> pOutSessionId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IOAuthProcedure)

        ::nn::Result PrepareAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PrepareAsync, (pOutContext));
        }

        ::nn::Result GetRequest(::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequest, (pOutRequestUrl, pOutCallbackUri));
        }

        ::nn::Result ApplyResponse(const ::nn::sf::InArray<char>& response) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetData() != nullptr && _.GetLength() > 0), response)), "_.GetData() != nullptr && _.GetLength() > 0 (where _ = response)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ApplyResponse, (response));
        }

        ::nn::Result ApplyResponseAsync(::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::sf::InArray<char>& response) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetData() != nullptr && _.GetLength() > 0), response)), "_.GetData() != nullptr && _.GetLength() > 0 (where _ = response)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ApplyResponseAsync, (pOutContext, response));
        }

        ::nn::Result Suspend(::nn::sf::Out<::nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Suspend, (pOutSessionId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IOAuthProcedure
    {
    public:
        nn::Result PrepareAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
        nn::Result GetRequest(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT;
        nn::Result ApplyResponse(const nn::sf::InArray<char>& response) NN_NOEXCEPT;
        nn::Result ApplyResponseAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::sf::InArray<char>& response) NN_NOEXCEPT;
        nn::Result Suspend(nn::sf::Out<nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result PrepareAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT;
    nn::Result GetRequest(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT;
    nn::Result ApplyResponse(const nn::sf::InArray<char>& response) NN_NOEXCEPT;
    nn::Result ApplyResponseAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::sf::InArray<char>& response) NN_NOEXCEPT;
    nn::Result Suspend(nn::sf::Out<nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::account::http::IOAuthProcedure))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PrepareAsync, (pOutContext));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequest, (::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequest, (pOutRequestUrl, pOutCallbackUri));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ApplyResponse, (const ::nn::sf::InArray<char>& response))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ApplyResponse, (response));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ApplyResponseAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::sf::InArray<char>& response))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ApplyResponseAsync, (pOutContext, response));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Suspend, (::nn::sf::Out<::nn::account::detail::Uuid> pOutSessionId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Suspend, (pOutSessionId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::account::http::IOAuthProcedure>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::account::http::IOAuthProcedure))

    // nn::Result PrepareAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareAsync)

    // nn::Result GetRequest(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutRequestUrl, 0, (::nn::sf::Out<::nn::account::RequestUrl>), 4096, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutCallbackUri, 1, (::nn::sf::Out<::nn::account::CallbackUri>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (pOutRequestUrl, pOutCallbackUri))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRequestUrl), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCallbackUri)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequest)

    // nn::Result ApplyResponse(const nn::sf::InArray<char>& response) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ApplyResponse)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(response, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (response))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(response)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ApplyResponse)

    // nn::Result ApplyResponseAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::sf::InArray<char>& response) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ApplyResponseAsync)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(response, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (response))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutContext, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutContext))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutContext), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(response)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ApplyResponseAsync)

    // nn::Result Suspend(nn::sf::Out<nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Suspend)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSessionId, (::nn::account::detail::Uuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSessionId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSessionId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Suspend)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::RequestUrl), 4096, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::CallbackUri), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::detail::Uuid), 16, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::account::http::IOAuthProcedure, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::account::http::IOAuthProcedure))

    // nn::Result PrepareAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PrepareAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareAsync)
    }

    // nn::Result GetRequest(nn::sf::Out<nn::account::RequestUrl> pOutRequestUrl, nn::sf::Out<nn::account::CallbackUri> pOutCallbackUri) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequest, (::nn::sf::Out<::nn::account::RequestUrl> pOutRequestUrl, ::nn::sf::Out<::nn::account::CallbackUri> pOutCallbackUri))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRequestUrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCallbackUri)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequest)
    }

    // nn::Result ApplyResponse(const nn::sf::InArray<char>& response) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ApplyResponse, (const ::nn::sf::InArray<char>& response))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ApplyResponse)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(response)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ApplyResponse)
    }

    // nn::Result ApplyResponseAsync(nn::sf::Out<nn::sf::SharedPointer<nn::account::detail::IAsyncContext>> pOutContext, const nn::sf::InArray<char>& response) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ApplyResponseAsync, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>> pOutContext, const ::nn::sf::InArray<char>& response))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ApplyResponseAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(response)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ApplyResponseAsync)
    }

    // nn::Result Suspend(nn::sf::Out<nn::account::detail::Uuid> pOutSessionId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Suspend, (::nn::sf::Out<::nn::account::detail::Uuid> pOutSessionId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Suspend)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSessionId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Suspend)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::account::http::IOAuthProcedure>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::account::http::IOAuthProcedure))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRequestUrl)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutCallbackUri)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRequestUrl),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutCallbackUri)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ApplyResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(response)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetData() != nullptr && _.GetLength() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(response)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ApplyResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(response)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ApplyResponseAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(response)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::account::detail::IAsyncContext>), pOutContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_.GetData() != nullptr && _.GetLength() > 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(response)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ApplyResponseAsync)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutContext),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(response)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutContext, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Suspend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Suspend)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSessionId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ApplyResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ApplyResponseAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Suspend)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::account::http::IOAuthProcedure))
