﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace account {

//! @brief ニンテンドーアカウントの内部ID
struct NintendoAccountId
{
    uint64_t id;

    inline NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return id != 0x00;
    }
};
const NintendoAccountId InvalidNintendoAccountId = {0x00};

inline bool operator==(const NintendoAccountId& lhs, const NintendoAccountId& rhs) NN_NOEXCEPT
{
    return lhs.id == rhs.id;
}
inline bool operator!=(const NintendoAccountId& lhs, const NintendoAccountId& rhs) NN_NOEXCEPT
{
    return !(lhs == rhs);
}

} // ~namespace nn::account
}
