﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Config.h>

#include <nn/nn_Common.h>

/** @file
    @brief  本体機能向けに公開されるアカウントシステムのスペックを記述します。
 */

namespace nn { namespace account {

//! @name アカウントシステムの数値的な性能
//! @{

/**
    @brief 本体機能がユーザーに設定可能な任意データの大きさ (バイト数)
    @details
        本体機能がユーザーごとに設定可能な任意データの大きさ (バイト数) を表します。
*/
const size_t UserDataBytesMax = 128;

/**
    @deprecated
    @brief この定数は廃止予定です。 nn::account::NintendoAccountAuthorizationCodeLengthMax を使用してください。
*/
NN_DEPRECATED
const size_t NintendoAccountAuthorizationCodeSizeMax = NintendoAccountAuthorizationCodeLengthMax;

/**
    @deprecated
    @brief この定数は廃止予定です。 nn::account::NintendoAccountIdTokenLengthMax を使用してください。
*/
NN_DEPRECATED
const size_t NintendoAccountIdTokenSizeMax = NintendoAccountIdTokenLengthMax;

/**
    @brief 有効な ExternalNetworkServiceAccountRegistrar オブジェクトの作成に必要なバッファの大きさ(バイト数)
*/
const size_t RequiredBufferSizeForExternalNetworkServiceAccountRegistrar = 34 * 4096;

//! @}

}} // ~namespace nn::account
