﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.IO;

namespace Nintendo.SystemUpdateSdev
{
    public class CollectMeasurementData
    {
        const string ToolName = "SystemUpdateSdev";

        public static bool Collect(ref string[] rawArgs, int exitCode, DateTime bootTime)
        {
            InitializeSdev.CollectMeasurementMutex toolMutex = InitializeSdev.CollectMeasurementMutex.GetInstance();
            if (toolMutex.WaitOne(120000) == false)
            {
                return false;
            }

            DateTimeOffset bootTimeOffset = new DateTimeOffset(bootTime);
            InitializeSdev.CollectMeasurementDataCore measure = new InitializeSdev.CollectMeasurementDataCore(ToolName, rawArgs, exitCode, bootTimeOffset.ToString());
            bool returnValue = measure.Write();

            toolMutex.ReleaseMutex();

            return returnValue;
        }
    }
}
