﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.RecoveryBoot
{
    public class BootQspiMode
    {
        public bool m_IsVerbose;

        public BootQspiMode()
        {
        }

        public void PrintProgress(string message)
        {
            if (m_IsVerbose)
            {
                Console.Out.WriteLine(message);
            }
            else
            {
                Console.Out.Write(".");
            }
        }

        public void PrintError(int error, string message)
        {
            if (m_IsVerbose)
            {
                Console.Out.WriteLine("[ERROR] {0} ({1})", message, error);
            }
        }

        public int Execute(Argument args)
        {
            m_IsVerbose = args.Verbose;

            PrintProgress("Upload image.");

            BridgeUpdate update = new BridgeUpdate();
            if (!update.UpdateTarget(args.Target, args.FirmwareImagePath, true))
            {
                return -1;
            }

            return 0;
        }
    }
}
