﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Bridge;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeSdev
{
    class DisplayInformations
    {
        public DisplayInformations()
        {
        }

        public ExitStatus AvailableFirmwareVersions(SdevInitializeCommandArgument arguments)
        {
            List<string> firmwareVersionsList = new List<string>();
            bool bRet = FirmwareResourceSpecifier.EnumerateAllVersions(ref firmwareVersionsList);

            if (bRet == false)
            {
                LOG.LogLine(LOG.Level.LOG_ERROR, "Failed to get available versions.");
                return ExitStatus.Failure;
            }

            foreach (string firmwareVersion in firmwareVersionsList)
            {
                LOG.LogLine(firmwareVersion);
            }

            return ExitStatus.Success;
        }

        public ExitStatus ListAvailableTargets(SdevInitializeCommandArgument arguments)
        {
            ExitStatus eState = ExitStatus.Failure;

            ProcessAccessor.StopTargetManager();

            string[] EnumerateIps = new string[0];
            int[] EnumeratePorts = new int[0];
            string[] EnumerateNames = new string[0];
            string[] EnumerateMacs = new string[0];
            string[] EnumerateSerials = new string[0];

            eState = TargetSpecifier.EnumerateTargets(out EnumerateIps, out EnumeratePorts, out EnumerateNames, out EnumerateMacs, out EnumerateSerials);
            if (eState != ExitStatus.Success)
            {
                return eState;
            }

            foreach (string mac in EnumerateMacs)
            {
                Console.WriteLine(mac);
            }

            return eState;
        }
    }
}
