﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Bridge;

namespace Nintendo.InitializeSdev
{
    public class BlinkLed
    {
        public static ExitStatus Execute(string ipAddress)
        {
            ExitStatus result = ExitStatus.Success;
            BridgeControl control = new BridgeControl();

            if (control.Open(ipAddress))
            {
                try
                {
                    for (int i = 0; i < 5; i++)
                    {
                        control.LED(BridgeControl.LED_ID.SD, BridgeControl.LED_MODE.OFF);
                        control.LED(BridgeControl.LED_ID.GC, BridgeControl.LED_MODE.ON);

                        System.Threading.Thread.Sleep(1000);

                        control.LED(BridgeControl.LED_ID.SD, BridgeControl.LED_MODE.ON);
                        control.LED(BridgeControl.LED_ID.GC, BridgeControl.LED_MODE.OFF);

                        System.Threading.Thread.Sleep(1000);
                    }

                    control.LED(BridgeControl.LED_ID.SD, BridgeControl.LED_MODE.NORMAL);
                    control.LED(BridgeControl.LED_ID.GC, BridgeControl.LED_MODE.NORMAL);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e);
                    result = ExitStatus.Failure;
                }
            }
            else
            {
                result = ExitStatus.Failure;
            }

            return result;
        }
    }
}
