﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.InitializeSdev;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeEdev
{
    partial class EdevInitializer
    {
        public ExitStatus ExecuteBootSafeMode(EdevInitializeCommandArgument arguments)
        {
            Argument = arguments;
            ExitStatus eStatus = ExitStatus.Failure;

            if (UsbAccessCheck() != ExitStatus.Success)
            {
                return ExitStatus.Failure;
            }

            firmwareResource = new FirmwareResourceSpecifier();
            if (firmwareResource.SetVersion(GetVersionString()) == false)
            {
                return ExitStatus.Failure;
            }
            string targetManagerPath = firmwareResource.GetFileNameOfFirm(FirmwareType.Host_TargetManager);
            string oldTargetManagerPath = firmwareResource.GetFileNameOfFirm(FirmwareType.Host_TargetManager_Old);
            if (FirmwareResourceSpecifier.CheckFilePath(nameof(targetManagerPath), targetManagerPath) == false)
            {
                return ExitStatus.Failure;
            }
            if (FirmwareResourceSpecifier.CheckFilePath(nameof(oldTargetManagerPath), oldTargetManagerPath) == false)
            {
                return ExitStatus.Failure;
            }

            if (ExecutePluginsBeforeInitialize() != ExitStatus.Success)
            {
                return ExitStatus.Failure;
            }

            LOG.LogLine("Stop NintendoTargetManager and check target information.");

            if (StopTargetManager() != ExitStatus.Success)
            {
                return ExitStatus.Failure;
            }

            TargetInnerClass targetKey = new TargetInnerClass(string.Empty, TargetInnerClass.TargetType.TargetInner_Other);

            string targetArgumentString = null;
            EdevInitializeCommandArgument.TargetArgumentType taragetArgumentType = EdevInitializeCommandArgument.TargetArgumentType.TypeOther;
            if (!arguments.ParseTarget(ref targetArgumentString, ref taragetArgumentType))
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Cannot specify target. Please set --target.");
                return ExitStatus.Failure;
            }

            LOG.LogLine(LOG_LEVEL.LOG_INFO2, "EDEV target argument '{0}', type '{1}'", targetArgumentString, taragetArgumentType.ToString());

            TargetManagerAccess.UnregisterTarget(targetManagerPath, targetArgumentString, taragetArgumentType, Argument.Verbose);

            if (!TargetSpecifier.GetTargetKey(ref targetKey, targetArgumentString, taragetArgumentType, targetManagerPath))
            {
                return ExitStatus.Failure;
            }

            LOG.LogLine(LOG_LEVEL.LOG_INFO2, "EDEV target key is {0} (type:{1})", targetKey.Value != null ? targetKey.Value : string.Empty, targetKey.Type.ToString());

            LOG.LogLine("Execute boot safemode.");

            ProcessingProgress dummyProgress = new ProcessingProgress();
            eStatus = ExecuteBootSafeMode(ref dummyProgress, targetKey, targetManagerPath, oldTargetManagerPath);

            if (eStatus != ExitStatus.Success)
            {
                goto quit;
            }

            LOG.LogLine("--xxxx-bsf command SUCCEEDED.");

        quit:
            return eStatus;
        }
    }
}
