﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using LOG = Nintendo.InitializeSdev.Logger;
using LOG_LEVEL = Nintendo.InitializeSdev.Logger.Level;

namespace Nintendo.InitializeEdev
{
    class DisplayInformations
    {
        public DisplayInformations()
        {
        }

        public ExitStatus AvailableFirmwareVersions(EdevInitializeCommandArgument arguments)
        {
            List<string> firmwareVersionsList = new List<string>();
            bool bRet = Nintendo.InitializeSdev.FirmwareResourceSpecifier.EnumerateAllVersions(ref firmwareVersionsList);

            if (bRet == false)
            {
                LOG.LogLine(LOG.Level.LOG_ERROR, "Failed to get available versions.");
                return ExitStatus.Failure;
            }

            foreach (string firmwareVersion in firmwareVersionsList)
            {
                LOG.LogLine(firmwareVersion);
            }

            return ExitStatus.Success;
        }

        public ExitStatus ListAvailableTargets(EdevInitializeCommandArgument arguments)
        {
            InitializeSdev.ProcessAccessor.StopTargetManager();

            string[] EnumerateNames = new string[0];
            string[] EnumerateSerials = new string[0];
            string[] EnumerateAddresses = new string[0];

            InitializeSdev.FirmwareResourceSpecifier firmwareResource = new InitializeSdev.FirmwareResourceSpecifier();
            if (firmwareResource.SetVersion(InitializeSdev.FirmwareResourceSpecifier.GetUpToDateVersion()) == false)
            {
                return ExitStatus.Failure;
            }
            string targetManagerPath = firmwareResource.GetFileNameOfFirm(InitializeSdev.FirmwareType.Host_TargetManager);
            int num = InitializeSdev.TargetManagerAccess.EnumerateUsbTargets(targetManagerPath, out EnumerateNames, out EnumerateSerials, out EnumerateAddresses);

            foreach (string serial in EnumerateSerials)
            {
                Console.WriteLine(serial);
            }

            InitializeSdev.ProcessAccessor.StopTargetManager();

            return ExitStatus.Success;
        }
    }
}
