﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using HidSharp;
using System.Diagnostics;

namespace Nintendo.DebugBoardPlugin
{
    public class DebugBoardDevice
    {
        private readonly HidDevice device;
        public DebugBoardDevice(HidDevice connectedDevice)
        {
            device = connectedDevice;
            // GPIO3 の有効化
            Ft260Library.EnableInterruptAndWakeUp(device, false);
            // GPIO4, GPIO5 の有効化
            Ft260Library.EnableUartDcdRi(device, false);

            byte[] bytes;
            Ft260Library.GetGpioSettings(device, out bytes);
            Debug.WriteLine("Gpio Value  : {0},", (Ft260Library.Gpio)bytes[1]);
            Debug.WriteLine("Gpio Dir (output pins): {0},", (Ft260Library.Gpio)bytes[2]);
            Debug.WriteLine("GpioEx Value: {0},", (Ft260Library.Gpio)bytes[3]);
            Debug.WriteLine("GpioEx Dir: {0},", (Ft260Library.Gpio)bytes[4]);

            Ft260Library.SetGpioDirection(device, Ft260Library.Gpio.GPIO3, Ft260Library.GpioDirection.Output);
            Ft260Library.SetGpioDirection(device, Ft260Library.Gpio.GPIO4, Ft260Library.GpioDirection.Output);
            Ft260Library.SetGpioDirection(device, Ft260Library.Gpio.GPIO5, Ft260Library.GpioDirection.Output);
            Ft260Library.SetGpioDirection(device, Ft260Library.GpioExt.GPIOF, Ft260Library.GpioDirection.Output);

            Ft260Library.WriteGpio(device, Ft260Library.Gpio.GPIO3, true);
            Ft260Library.WriteGpio(device, Ft260Library.Gpio.GPIO4, true);
            Ft260Library.WriteGpio(device, Ft260Library.Gpio.GPIO5, true);
            Ft260Library.WriteGpio(device, Ft260Library.GpioExt.GPIOF, true);
        }
        public void PressReset(bool pressed)
        {
            // RST_SYS-RST-FT260S
            Ft260Library.WriteGpio(device, Ft260Library.Gpio.GPIO4 /* DIO10 */, !pressed);
        }
        public void PressPowerButton(bool pressed)
        {
            // RST_MAX77620-EN0-FT260S
            Ft260Library.WriteGpio(device, Ft260Library.Gpio.GPIO5 /* DIO11 */, !pressed);
        }
        public void PressVolUp(bool pressed)
        {
            // BTN-VOL-UP-FT260S
            Ft260Library.WriteGpio(device, Ft260Library.GpioExt.GPIOF /* DIO9 */, !pressed);
        }
        public void ConnectUsb(bool connected)
        {
            // USB-SW-SEL
            Ft260Library.WriteGpio(device, Ft260Library.Gpio.GPIO3 /* DIO8 */, connected);
        }

        public static IEnumerable<DebugBoardDevice> GetConnectedDevices()
        {
            return Ft260Library
                .GetConnectedDevices()
                .Select(device => new DebugBoardDevice(device))
                .ToArray();
        }
    }
}
