﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using LOG = Nintendo.CopyCliCoreLibrary.Logger;
using LOG_LEVEL = Nintendo.CopyCliCoreLibrary.Logger.Level;

namespace Nintendo.CopyCliCoreLibrary
{
    /// <summary>
    /// C++/CLI プロジェクトに依存するDLLを C++/CLI ライブラリを利用するアプリケーションにコピーする
    ///
    /// C++/CLI プロジェクトとそれに依存するDLLを作った場合、C++/CLI ライブラリを呼び出すプロジェクトにDLLがコピーされません。 (Visual Studio の仕様)
    /// このツールでは C++/CLI ライブラリを呼び出すプロジェクトを探しだしてDLLをコピーします。
    ///
    /// あとこのツールは RunnerTools 群とは独立で動作できるようにするために ToolFoundation は用いていない。
    /// </summary>
    class Program
    {
        static private void Usage()
        {
            LOG.LogLine("Usage: CopyCliCoreLibrary [.sln file path] [substitute .sln file path] [c++/cli .vcxproj file path] [dependent dll's .vcxproj file path] [Build Configuration] [Build Platform]");
        }

        static private void DumpArguments(string[] args)
        {
            LOG.LogLine("arguments:");
            foreach (string arg in args)
            {
                LOG.LogLine("  {0}", arg);
            }
        }

        static int Main(string[] args)
        {
            // DumpArguments(args);

            if (args.Length < 4)
            {
                Usage();
                return 1;
            }

            string mainSlnFilePath = args[0];
            string substituteSlnFilePath = args[1];
            string cliProjectPath = args[2];
            string dependentProjectPath = args[3];
            string buildConfiguration = args.Length >= 5 ? args[4] : "Release";
            string buildPlatform = args.Length >= 6 ? args[5] : "x86";

            ParseProject parseProject = new ParseProject();
            if (!parseProject.CopyDependentDllOfCliLibrary(mainSlnFilePath, substituteSlnFilePath, cliProjectPath, dependentProjectPath, buildConfiguration, buildPlatform))
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Copy C++/Cli dependent dll failed.");
                return -1;
            }

            LOG.LogLine("Copy C++/Cli dependent dll succeeded.");
            return 0;
        }
    }
}
