﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ControlTarget
{
    public class RetryUtility
    {
        public class RetryOverException : Exception
        {
            public RetryOverException() { }
            public RetryOverException(string message) : base(message) { }
        }
        public class NoRetryException : Exception
        {
            public NoRetryException() { }
            public NoRetryException(string message) : base(message) { }
        }

        public static T Do<T>(Func<T> action, Action<Exception> failureAction, int numRetries, TimeSpan interval)
        {
            return Do(action, failureAction, (es) => { }, numRetries, interval);
        }

        public static T Do<T>(Func<T> action, Action<Exception> failureAction, Action<List<Exception>> allFailureAction, int numRetries, TimeSpan interval)
        {
            var exceptions = new List<Exception>();

            for (int i = 0; i < numRetries + 1; i++)
            {
                try
                {
                    return action();
                }
                catch (Exception e)
                {
                    exceptions.Add(e);
                    try
                    {
                        failureAction(e);
                    }
                    catch (RetryUtility.NoRetryException nre)
                    {
                        exceptions.Add(nre);
                        break;
                    }
                }

                Task.Delay(interval).Wait();
            }

            allFailureAction(exceptions);

            throw exceptions.Last();
        }

        public static void Do(Action action, Action<Exception> failureAction, Action<List<Exception>> allFailureAction, int numRetries, TimeSpan interval)
        {
            Do<object>(
                () =>
                {
                    action();
                    return null;
                },
                failureAction,
                allFailureAction,
                numRetries,
                interval);
        }

        public static void Do(Action action, Action<Exception> failureAction, int numRetries, TimeSpan interval)
        {
            Do<object>(
                () =>
                {
                    action();
                    return null;
                },
                failureAction,
                numRetries,
                interval);
        }
    }
}
