﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.ControlTarget
{
    public class EscapeSequenceEliminator
    {
        public enum HandlingType
        {
            Skip,
            Accept
        }

        public HandlingType Put(byte input)
        {
            switch (state)
            {
                case HandlingState.NoEscapeSequence:
                    switch (GetByteType(input))
                    {
                        case ByteType.OtherType:
                            state = HandlingState.NoEscapeSequence;
                            return HandlingType.Accept;
                        case ByteType.EscapeSequenceStart:
                            state = HandlingState.InEscapeSequence;
                            return HandlingType.Skip;
                        case ByteType.CsiStart:
                            state = HandlingState.NoEscapeSequence;
                            return HandlingType.Accept;
                        case ByteType.EscapeSequenceEnd:
                            state = HandlingState.NoEscapeSequence;
                            return HandlingType.Accept;
                        default:
                            throw new Exception("Unknown state");
                    }
                case HandlingState.InEscapeSequence:
                    switch (GetByteType(input))
                    {
                        case ByteType.OtherType:
                            state = HandlingState.NoEscapeSequence;
                            return HandlingType.Skip;
                        case ByteType.EscapeSequenceStart:
                            state = HandlingState.InEscapeSequence;
                            return HandlingType.Skip;
                        case ByteType.CsiStart:
                            state = HandlingState.InCsi;
                            return HandlingType.Skip;
                        case ByteType.EscapeSequenceEnd:
                            state = HandlingState.NoEscapeSequence;
                            return HandlingType.Skip;
                        default:
                            throw new Exception("Unknown state");
                    }
                case HandlingState.InCsi:
                    switch (GetByteType(input))
                    {
                        case ByteType.OtherType:
                            state = HandlingState.InCsi;
                            return HandlingType.Skip;
                        case ByteType.EscapeSequenceStart:
                            state = HandlingState.InCsi;
                            return HandlingType.Skip;
                        case ByteType.CsiStart:
                            state = HandlingState.InCsi;
                            return HandlingType.Skip;
                        case ByteType.EscapeSequenceEnd:
                            state = HandlingState.NoEscapeSequence;
                            return HandlingType.Skip;
                        default:
                            throw new Exception("Unknown state");
                    }
                default:
                    throw new Exception("Unexpected enum value");
            }
        }

        public int CopyWithElimination(byte[] outBuffer, byte[] bytes, int count)
        {
            int numWrite = 0;
            for (int i = 0; i < count; i++)
            {
                var onebyte = bytes[i];
                switch (Put(onebyte))
                {
                    case HandlingType.Skip:
                        break;
                    case HandlingType.Accept:
                        outBuffer[numWrite++] = onebyte;
                        break;
                    default:
                        break;
                }
            }

            return numWrite;
        }

        private ByteType GetByteType(byte input)
        {
            switch (input)
            {
                case 0x1b:
                    return ByteType.EscapeSequenceStart;
                case 0x5b:
                    return ByteType.CsiStart;
                case 0x48:
                case 0x66:
                case 0x41:
                case 0x42:
                case 0x43:
                case 0x44:
                case 0x73:
                case 0x75:
                case 0x4a:
                case 0x4b:
                case 0x6d:
                case 0x68:
                case 0x6c:
                case 0x70:
                    return ByteType.EscapeSequenceEnd;
                default:
                    return ByteType.OtherType;
            }
        }

        private enum ByteType
        {
            OtherType,
            EscapeSequenceStart,
            CsiStart,
            EscapeSequenceEnd
        }

        private enum HandlingState
        {
            NoEscapeSequence,
            InEscapeSequence,
            InCsi,
        }

        private HandlingState state = HandlingState.NoEscapeSequence;
    }
}
