﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.IO;
using System.IO.Ports;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace Nintendo.ControlTarget
{
    public class UBoot
    {
        public UBoot(SerialPortWrapper port, string uBootCommand = "boot")
        {
            this.port = port;
            UBootCommand = uBootCommand;
        }

        public void Boot()
        {
            Trace.WriteLine("Send boot command to UBoot.");
            port.SendCommand(UBootCommand);
        }

        public void EnsureBoot()
        {
            if (IsRunning())
            {
                Trace.WriteLine("UBoot is maybe available.");
                Boot();
            }
            else
            {
                Trace.WriteLine("UBoot is maybe not running.");
            }
        }

        public bool IsRunning()
        {
            // version コマンドを打ち込んで "U-Boot" の文字列が返ってきたら起動しているものとして扱う
            return Regex.IsMatch(port.SendCommand("version"), ".*U-Boot.*", RegexOptions.Multiline);
        }

        private SerialPortWrapper port;
        private string UBootCommand;
    }
}
