﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Net;
using System.IO;

namespace Nintendo.ControlTarget
{
    public class HtcDaemonAccessor : HtcsAccessorBase
    {
        public HtcDaemonAccessor()
        {
        }

        public override IPEndPoint PortOfHtcs
        {
            get
            {
                return new IPEndPoint(IPAddress.Parse("127.0.0.1"), 8002);
            }
        }

        public override FileInfo HtcsDaemonPath
        {
            get { return PathUtility.GetHtcDaemonPath(); }
        }
    }
}
