﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.ControlTarget.ConsoleShell;

namespace Nintendo.ControlTarget
{
    public class TerminateCommandArgument : CommonTargetCommand
    {
        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    var coodinator = new RunnerToolCoordinator(info.GetSerialNumber());

                    using (var targetOwnership = coodinator.RequestOwnership())
                    {
                        Trace.WriteLine($"Try to connect: {info.GetSerialNumber()}");

                        tmapiAccessor.ConnectTarget(info.GetTargetHandle());

                        System.Net.IPEndPoint endPoint;
                        try
                        {
                            endPoint = tmapiAccessor.FindService("iywys@$csForRunnerTools", info.GetTargetHandle());
                        }
                        catch (HtcServiceNotFound)
                        {
                            try
                            {
                                endPoint = tmapiAccessor.FindService("@csForRunnerTools", info.GetTargetHandle());
                            }
                            catch (HtcServiceNotFound)
                            {
                                throw new Exception("Found no shell service.");
                            }
                        }

                        Trace.WriteLine($"Try to connect: {endPoint.ToString()}");

                        var csAccessor = new ConsoleShellAccessor(new ConsoleShellMessenger(endPoint));

                        Trace.WriteLine($"Try to tarminate applications. serial={info.GetSerialNumber()}");

                        csAccessor.TerminateAllApplications();
                    }
                });
        }
    }
}
