﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using Nintendo.Foundation.IO;
using Nintendo.Bridge;

namespace Nintendo.ControlTarget
{
    public class SetBatteryLevelCommand : CommonTargetCommand
    {
        [CommandLineValue(0, ValueName = "Battery level", Description = "Specifies a battery level(enough|no-boost).")]
        public string BatteryLevel { get; set; }

        public override void Run()
        {
            RunHostBridgeTargetCommand(
                (name, info, target, tmapiAccessor) =>
                {
                    tmapiAccessor.EnsureStart();
                    var targetInfo = tmapiAccessor.GetTargetInfo(name);

                    if (targetInfo.GetHardwareType().StartsWith("EDEV"))
                    {
                        throw new Exception(string.Format("This function doesn't support {0}. Please use SDEV.", targetInfo.GetHardwareType()));
                    }
                    if (targetInfo.GetConnectionType() != "Ethernet")
                    {
                        throw new Exception("This function requires host bridge connection.");
                    }
                    Telnet hbTelnet = new Telnet();
                    if (!hbTelnet.Connect(targetInfo.GetIpAddress()))
                    {
                        throw new Exception("HostBridge connection failed.");
                    }

                    var vCellAverage = 0xB400;
                    var socRep = 0x3200;

                    if (BatteryLevel == "enough")
                    {
                        // 3.60
                        vCellAverage = 0xB400;

                        // 電池残量表示 49%（生値 50%）
                        socRep = 0x3200;
                    }
                    else if (BatteryLevel == "no-boost")
                    {
                        // 3.28 V
                        vCellAverage = 0xA400;

                        // 電池残量表示 1%（生値 3%）
                        socRep = 0x0300;
                    }
                    else
                    {
                        throw new Exception("Invalid battery level.");
                    }

                    string commandForVoltage = String.Format("ni2c_fg_test -a 0x19 -w 0x{0,0:X4}", vCellAverage);
                    string commandForPercentage = String.Format("ni2c_fg_test -a 0x06 -w 0x{0,0:X4}", socRep);

                    hbTelnet.Login();
                    hbTelnet.WaitCommand(commandForVoltage);
                    hbTelnet.WaitCommand(commandForPercentage);
                }
            );
        }
    }
}
