﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.Bridge
{
    public class BridgeUpdate
    {
        public bool Verbose { get; set; }

        public BridgeUpdate()
        {
            Verbose = false;
        }

        bool upload(string address, string file, string name)
        {
            Ftp ftp = new Ftp();

            try
            {
                Uri uri = new Uri("ftp://" + address + "/" + name);

                ftp.Upload(uri, file);
            }
            catch (Exception e)
            {
                if (Verbose)
                {
                    Console.WriteLine(e);
                    Console.WriteLine("Failed to Upload {0}.", file);
                    Console.WriteLine("Please confirm the specified IP address and the path.");
                }
                return false;
            }

            if (Verbose)
            {
                Console.WriteLine("Uploaded {0} as {1}.", file, name);
            }
            return true;
        }

        public bool UpdateBridge(string address, string file, bool recovery = false)
        {
            if (!upload(address, file, "package.nhf"))
            {
                return false;
            }

            Telnet telnet = new Telnet();
            if (!telnet.Connect(address))
            {
                return false;
            }

            bool result = true;

            try
            {
                telnet.Login();

                if (recovery)
                {
                    telnet.WaitCommand("/bin/firmupdater -u 2 -x /var/ftp/package.nhf");
                }
                else
                {
                    telnet.WaitCommand("/bin/firmupdater -x /var/ftp/package.nhf");
                    telnet.WaitCommand("reboot");
                }
            }
            catch (Exception e)
            {
                if (Verbose)
                {
                    Console.WriteLine(e);
                }
                result = false;
            }

            telnet.Exit();
            return result;
        }

        public bool UpdateTarget(string address, string file, bool reboot = false)
        {
            if (!upload(address, file, "bootimage.bin"))
            {
                return false;
            }

            Telnet telnet = new Telnet();
            if (!telnet.Connect(address))
            {
                return false;
            }

            bool result = true;

            try
            {
                telnet.Login();
                telnet.WaitCommand("/bin/norwriter -b /var/ftp/bootimage.bin");
                if (reboot)
                {
                    string cmd = "";
                    cmd += "ngpio_test -p0 -d1; ngpio_test -p2 -d1; ";
                    cmd += "ngpio_test -p0 -w1; ";
                    cmd += "ngpio_test -p2 -w0; usleep 100; ngpio_test -p2 -w1; ";
                    cmd += "usleep 500; ngpio_test -p0 -w0";
                    telnet.WaitCommand(cmd);
                }
            }
            catch (Exception e)
            {
                if (Verbose)
                {
                    Console.WriteLine(e);
                }
                result = false;
            }

            telnet.Exit();
            return result;
        }
    }
}
