﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.Bridge
{
    public class Ftp
    {
        public bool Verbose { get; set; }

        public Ftp()
        {
            Verbose = false;
        }

        public void Upload(Uri uri, string file)
        {
            FtpWebRequest req = (FtpWebRequest)WebRequest.Create(uri);
            req.Credentials = new NetworkCredential("ftp", "");
            req.Method = WebRequestMethods.Ftp.UploadFile;
            req.KeepAlive = false;
            req.UseBinary = true;
            req.UsePassive = true;
            req.Proxy = null;

            Stream reqStearm = req.GetRequestStream();
            FileStream fs = new FileStream(file, FileMode.Open, FileAccess.Read);

            byte[] buffer = new byte[16384];
            while (true)
            {
                int readSize = fs.Read(buffer, 0, buffer.Length);
                if (readSize == 0)
                {
                    break;
                }
                reqStearm.Write(buffer, 0, readSize);
            }
            fs.Close();
            reqStearm.Close();

            FtpWebResponse res = (FtpWebResponse)req.GetResponse();
            if (Verbose)
            {
                Console.WriteLine("{0}: {1}", res.StatusCode, res.StatusDescription);
            }

            res.Close();
        }
    }
}
