﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace Nn.ResultTool
{
    public class ResultDefinitionPrinter
    {
        private static string ExcapeForDoxygen(string s)
        {
            return s.Replace(",", "\\,").Replace("\\\\,", "\\,");
        }

        private static void PrintResultRangeForCpp(IEnumerable<Nn.ResultTool.ResultRange> s, System.IO.TextWriter o, ModuleMap moduleMap)
        {
            foreach (var e in s)
            {
                var moduleNumber = moduleMap.GetModuleId(e.Module);
                {
                    var succession = new List<ResultRange>();
                    {
                        for (var r = e; r != null; r = r.Parent)
                        {
                            succession.Add(r);
                        }
                    }
                    var docMacro = e.Abstract
                        ? "defresulta"
                        : "defresult";
                    o.WriteLine(@"{7}//! @{0}{{{1},{2},{3},{4},{5},{6}}}",
                        docMacro, e.Module, ExcapeForDoxygen(e.Text), moduleNumber, e.Begin, e.End - 1,
                        string.Join("\\, ", succession.Select(r => r.Name).ToArray()),
                        new string(' ', e.Rank * 4));
                }
                {
                    var macro = e.Abstract
                        ? "NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT"
                        : "NN_DEFINE_ERROR_RANGE_RESULT";
                    var line = string.Format("{5}{0}({1}, {2}, {3}, {4});",
                        macro, e.Name, moduleNumber, e.Begin, e.End, new string(' ', e.Rank * 4));
                    o.WriteLine(line.TrimEnd());
                }
            }
        }

        public static void PrintResultRangeForCpp(string packageName, IEnumerable<Nn.ResultTool.ResultRange> s, System.IO.TextWriter o, ModuleMap moduleMap)
        {
            o.WriteLine(@"// package '{0}'", packageName);
            PrintResultRangeForCpp(s, o, moduleMap);
        }
    }
}
