﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace Nintendo.ManuHostTools.Commands
{
    public class ApplicationLaunchCommand : Command
    {
        private readonly string FirstArgument = "InstalledApplication";

        public UInt64 ProgramId { get; private set; }
        public string[] Arguments { get; private set; }

        public ApplicationLaunchCommand(UInt64 programId, string[] arguments)
        {
            var appendedArguments = new string[] { FirstArgument }.Concat(arguments).ToArray();

            this.ProgramId = programId;
            this.Arguments = appendedArguments;
        }

        protected override void SendBody(Stream stream)
        {
            var bodyBytes = new byte[GetBodySize()];
            var argString = string.Join(" ", this.Arguments);

            using (var ms = new MemoryStream(bodyBytes))
            using (var bw = new BinaryWriter(ms))
            {
                bw.Write(this.ProgramId);
                bw.Write(argString.ToCharArray());

            }
            stream.Write(bodyBytes, 0, bodyBytes.Length);
        }

        protected override CommandId GetCommandId()
        {
            return CommandId.LaunchApplication;
        }

        protected override UInt64 GetBodySize()
        {
            UInt64 bodySize = 0;

            bodySize += sizeof(ulong);
            bodySize += (UInt64)string.Join(" ", this.Arguments).Length;
            bodySize += 1;

            return bodySize;
        }
    }

}
