﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class Type
    {
        public const int UnknownSizeValue  = 100000;
        public const int PointerSizeValue  = 100001;
        public const int RegisterSizeValue = 100002;

        public string Name { get; private set; }
        public Type RealType { get; private set; }
        public string Namespace { get; private set; }
        public int Size { get; private set; }
        public int Alignment { get; private set; }
        public bool IsPredefined { get; private set; }
        public bool IsCommon { get; private set; }
        public bool IsPointerSize { get; private set; }
        public bool IsRegisterSize { get; private set; }

        public bool IsAbstract { get { return m_writer == null; } }
        public bool IsSizeUnknown { get { return Size == UnknownSizeValue; } }

        public string GlobalName
        {
            get
            {
                return Namespace.IsEmpty() ? Name : string.Concat(Namespace, "::", Name);
            }
        }
        public string RealGlobalName
        {
            get
            {
                return RealType.GlobalName;
            }
        }

        private Func<string> m_writer;

        public Type(
            string name,
            string ns,
            int size,
            int alignment,
            bool isPredefined,
            bool isCommon,
            bool isPointerSize,
            bool isRegisterSize,
            Func<string> writer)
        {
            Name = name;
            RealType = this;
            Namespace = ns;
            Size = size;
            Alignment = alignment;
            IsPredefined = isPredefined;
            IsCommon = isCommon;
            IsPointerSize = isPointerSize;
            IsRegisterSize = isRegisterSize;

            m_writer = writer;
        }

        public string MakeText() { return m_writer(); }

        public void UpdateRealType(Type t) { RealType = t; }
    }
}
