﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class LayoutConversionOperationMove : LayoutConversion.Operation
    {
        // ABI: レジスタ
        // SVC: レジスタ

        public LayoutConversionOperationMove(int abiIndex, int svcIndex, int storageSize, string name)
            : base("Move", abiIndex, new int[] { svcIndex }, storageSize, 0, name)
        {
        }

        public override void GenerateCodeInAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, int stackOffset)
        {
            this.ThrowUnexpectedOperation();
        }
        public override bool CanGenerateCodeInSvcToAbi(RegisterUsageTracer tracer)
        {
            tracer.Release(this.SvcIndex[0]);
            return tracer.TryOccupy(this.AbiIndex, "abi " + this.VariableName);
        }
        public override void GenerateCodeInSvcToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            tracer.Release(this.SvcIndex[0]);
            tracer.Occupy(this.AbiIndex, "abi " + this.VariableName);
            cg.Move(this.AbiIndex, this.SvcIndex[0], this.VariableName);
        }
        public override void GenerateCodeOutPrepareToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            throw new ErrorException("呼び出されないはずの関数");
        }
        public override void GenerateCodeOutAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            throw new ErrorException("呼び出されないはずの関数");
        }
        public override void GenerateCodeOutSvcToAbi(
            CodeGenerator cg,
            RegisterUsageTracer tracer,
            Dictionary<int, int> saveMap,
            int safeRegister,
            int stackOffset)
        {
            throw new ErrorException("呼び出されないはずの関数");
        }
    }
}
