﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeNrr
{
    /// <summary>
    /// コマンドラインオプションを設定するクラスです。
    /// </summary>
    class MakeNrrParams
    {
        public string MetaFilePath { get; set; }

        [CommandLineOption('o',
            Description = "Output NRR file path",
            IsRequired = true,
            DefaultValue = "")
        ]
        public string OutputFilePath { get; set; }


        [CommandLineValues(ValueName = "INPUT_FILES", Description = "Input NRO file paths.")]
        public string[] NroFilePaths { get; set; }
    }
}
