﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace MakeNro.Elf
{
    /// <summary>
    /// ELF ファイルのファイルタイプです。
    /// </summary>
    public enum ElfFileType
    {
        /// <summary>
        /// ファイルタイプがありません。
        /// </summary>
        None,

        /// <summary>
        /// 再配置可能なファイルです。
        /// </summary>
        RelocatableFile,

        /// <summary>
        /// 実行可能なファイルです。
        /// </summary>
        ExcutableFile,

        /// <summary>
        /// 共有オブジェクトファイルです。
        /// </summary>
        SharedObjectFile,

        /// <summary>
        /// コアファイルです。
        /// </summary>
        CoreFile,

        /// <summary>
        /// 環境固有のファイルです。
        /// </summary>
        LoOs,

        /// <summary>
        /// 環境固有のファイルです。
        /// </summary>
        HiOs,

        /// <summary>
        /// プロセッサ固有のファイルです。
        /// </summary>
        LoProc,

        /// <summary>
        /// プロセッサ固有のファイルです。
        /// </summary>
        HiProc,
    }
}
