﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Security.Cryptography;

namespace MakeDesc
{
    internal class PemRsaPrivateKeyFile
    {
        internal RSAParameters RsaPrivateKey
        {
            get
            {
                return Key.RsaPrivateKey;
            }
        }

        internal PemRsaPrivateKeyFile(string filename)
        {
            bool isPrivateKey = false;
            this.PrivateKey = null;

            string result = "";

            using (var sr = new StreamReader(filename))
            {
                string line;
                while((line = sr.ReadLine()) != null)
                {
                    if (line.IndexOf("-----") >= 0)
                    {
                        if (line == "-----BEGIN RSA PRIVATE KEY-----")
                        {
                            if (result.Length != 0)
                            {
                                throw new FileLoadException(Properties.Resources.Message_IncludedMultipleRSAKeys);
                            }
                            isPrivateKey = true;
                        }
                        if (line == "-----END RSA PRIVATE KEY-----")
                        {
                            isPrivateKey = false;
                        }
                        continue;
                    }
                    if (isPrivateKey)
                    {

                        result += line;
                    }
                }
            }

            if (this.PrivateKey != null)
            {
                throw new FileLoadException(Properties.Resources.Message_NotFoundRSAKey);
            }
            this.PrivateKey = System.Convert.FromBase64String(result);

            Key = new DerRsaPrivateKey(this.PrivateKey);
        }

        private byte[] PrivateKey;
        private DerRsaPrivateKey Key;
    }
}
