﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.FsFileCacheSimulator.Simulation
{
    internal static class Utility
    {
        public static bool ShouldPerformCoalescedRead(FileSystem.FileSystemType fileSystemType, FileSystem.StorageType storageType, FileRegion region1, FileRegion region2)
        {
            // FW バージョンによって結果が変わりうるので、実際にはアプリプロセスで正確に判断することはできない
            // またストレージ種類も実行時にアプリプロセス側から取得することはできないはず

            var read1 = FileSystem.AccessTimeCalculator.GetReadAccessTime(region1.Size, fileSystemType, storageType);
            var read2 = FileSystem.AccessTimeCalculator.GetReadAccessTime(region2.Size, fileSystemType, storageType);
            var bulkRead = FileSystem.AccessTimeCalculator.GetReadAccessTime(FileRegion.GetInclusion(region1, region2).Size, fileSystemType, storageType);
            return bulkRead < read1 + read2;
        }

        public static TimeSpan GetMemoryCopyTime(ulong size)
        {
            // ものすごくざっくりとした近似だけど、それなりに近い値になる
            long nanoSeconds = (long)size * 4 / 10;
            return TimeSpan.FromTicks(nanoSeconds / 100);
        }
    }
}
