﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.FsFileCacheSimulator
{
    internal class BitUtility
    {
        public static uint AlignDown(uint value, uint align)
        {
            return value & ~(align - 1);
        }
        public static ulong AlignDown(ulong value, ulong align)
        {
            return value & ~(align - 1);
        }

        public static uint AlignUp(uint value, uint align)
        {
            return (value + (align - 1)) & ~(align - 1);
        }
        public static ulong AlignUp(ulong value, ulong align)
        {
            return (value + (align - 1)) & ~(align - 1);
        }

        public static uint ResetLeastSignificantBit1(uint value)
        {
            return value & (value - 1);
        }
    }
}
