﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifdef LIBFDT_EXPORTS
#define LIBFDT_API __declspec(dllexport)
#else
#define LIBFDT_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

    // データの整合性チェック
    LIBFDT_API int FdtCheckHeader(const void *fdt); // fdt_check_header

    // ノード検索
    LIBFDT_API int FdtPathOffset(const void *fdt, const char *path); // fdt_path_offset
    LIBFDT_API int FdtNodeOffsetByPhandle(const void *fdt, uint32_t phandle); // fdt_node_offset_by_phandle
    LIBFDT_API int FdtNodeOffsetByCompatible(const void *fdt, int startoffset, const char *compatible); // fdt_node_offset_by_compatible
    LIBFDT_API int FdtParentOffset(const void *fdt, int nodeoffset); // fdt_parent_offset

    // ノード内容の探索
    LIBFDT_API int FdtGetprop(const void *fdt, int nodeoffset, const char *name, int *lenp); // fdt_getprop
    LIBFDT_API int FdtAddressCells(const void *fdt, int nodeoffset); // fdt_address_cells
    LIBFDT_API int FdtSizeCells(const void *fdt, int nodeoffset); // fdt_size_cells

    // デバッグ
    LIBFDT_API int FdtStrerror(int errval, char* buffer, size_t bufferSize); // fdt_strerror

// 欲しくなるかもしれない候補
#if 0
    LIBFDT_API int fdt_next_node(const void *fdt, int offset, int *depth);
    LIBFDT_API int fdt_first_subnode(const void *fdt, int offset);
    LIBFDT_API int fdt_next_subnode(const void *fdt, int offset);


    LIBFDT_API const char *fdt_get_name(const void *fdt, int nodeoffset, int *lenp);
#endif

#ifdef __cplusplus
} // extern "C"
#endif // __cplusplus
