﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Runtime.InteropServices;
using System.Text;

namespace DeviceTreeDataCollector.DeviceTree
{
    internal struct LibFdt
    {
        public static int HandleError(int result)
        {
            if (result < 0)
            {
                StringBuilder errorString = new StringBuilder(64);
                FdtStrerror(result, errorString, (uint)errorString.Capacity);
                // とりあえず、メッセージだけつけてそのまま上に投げる
                throw new InvalidOperationException($"LibFdt operation failed (see libfdt.h for description): {errorString.ToString()} ({result}) ");
            }
            return result;
        }

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtCheckHeader(byte[] fdt);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtPathOffset(byte[] fdt, string path);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtNodeOffsetByPhandle(byte[] fdt, uint phandle);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtNodeOffsetByCompatible(byte[] fdt, int startoffset, string compatible);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtParentOffset(byte[] fdt, int nodeoffset);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtGetprop(byte[] fdt, int nodeoffset, string name, out int lenp);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtAddressCells(byte[] fdt, int nodeoffset);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall)]
        public static extern int FdtSizeCells(byte[] fdt, int nodeoffset);

        [DllImport("LibFdtDll.dll", CallingConvention = CallingConvention.StdCall, CharSet = CharSet.Ansi)]
        private static extern int FdtStrerror(int errval, StringBuilder buffer, uint bufferSize);
    }
}
