﻿using DeviceTreeDataCollector.DeviceTree;
using System;
using System.Collections.Generic;
using System.Linq;

namespace DeviceTreeDataCollector
{
    public class DeviceTreeDataCollector
    {
        private InputParameterParser InputParameterParser;
        private List<CollectedProperty> CollectedPropertyList;

        public DeviceTreeDataCollector(string inputParameterFilePath)
        {
            InputParameterParser = new InputParameterParser(inputParameterFilePath);
            CollectedPropertyList = null;
        }

        public void DoCollection()
        {
            InputParameterParser.LoadParameter();
            var inputParameter = InputParameterParser.Parameter;
            if (!inputParameter.PropertyCollectParameters.Any())
            {
                throw new KeyNotFoundException($"PropertyCollectParameters was not found in parameter file '{InputParameterParser.FilePath}'");
            }

            var dtb = new DeviceTreeReader(inputParameter.BlobFilePath);
            var collectedPropertyList = new List<CollectedProperty>();
            foreach (var collectParam in inputParameter.PropertyCollectParameters)
            {
                DeviceTreeNode deviceNode;
                try
                {
                    deviceNode = dtb.FindNode(collectParam.NodePath);
                }
                catch
                {
                    Console.Error.WriteLine($"Specified node '{collectParam.NodePath}' could not be read (probably not exist) in device tree blob '{inputParameter.BlobFilePath}'");
                    throw;
                }

                DeviceTreeProperty property;
                try
                {
                    property = deviceNode.GetValue(collectParam.PropertyName, DeviceTreeProperty.GetPropertyType(collectParam.Type));
                }
                catch
                {
                    Console.Error.Write($"Specified property '{collectParam.PropertyName}' could not be read (probably not exist) from node '{collectParam.NodePath}' in device tree blob '{inputParameter.BlobFilePath}'");
                    throw;
                }

                collectedPropertyList.Add(new CollectedProperty(collectParam, property));
            }
            CollectedPropertyList = collectedPropertyList;
        }

        public IEnumerable<CollectedProperty> GetCollectedProperty()
        {
            if (CollectedPropertyList == null)
            {
                throw new InvalidOperationException("GetCollectedPropertyList was called before property list is ready. Call DoCollection() once to collect data.");
            }
            return CollectedPropertyList;
        }
    }
}
