﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace ContentsUploader.Models
{
    public static partial class Pms
    {
        // Demo 登録で利用
        [DataContract]
        public class DemoInfo
        {
            [DataMember(EmitDefaultValue = false, Name = "id", Order = 0)]
            public long id { get; set; }

            [DataMember(Name = "device_type", Order = 1)]
            public string deviceType { get; set; }

            [DataMember(Name = "product_class_code", Order = 2)]
            public string productClassCode { get; set; }

            [DataMember(Name = "form_code", Order = 3)]
            public string formCode { get; set; }

            [DataMember(Name = "initial_code", Order = 4)]
            public string initialCode { get; set; }

            [DataMember(Name = "platform", Order = 5)]
            public string platform { get; set; }

            [DataContract]
            public class Rating
            {
                [DataMember(Name = "system", Order = 0)]
                public string system { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "id", Order = 1)]
                public long id { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "descriptors", Order = 2)]
                public List<long> descriptors { get; set; }

                [DataMember(Name = "target_countries", Order = 3)]
                public List<string> targetCountries { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "ratings", Order = 6)]
            public List<Rating> ratings { get; set; }

            [DataMember(Name = "publisher", Order = 7)]
            public string publisher { get; set; }

            [DataMember(Name = "roms", Order = 8)]
            public List<string> roms { get; set; }

            [DataContract]
            public class Names
            {
                [DataContract]
                public class FormalName : ILanguageItem<FormalName>
                {
                    [DataMember(Name = "lang", Order = 0)]
                    public string lang { get; set; }

                    [DataMember(Name = "value", Order = 1)]
                    public string value { get; set; }
                }
                [DataMember(Name = "formal_names", Order = 0)]
                public List<FormalName> formalNames { get; set; }
            }
            [DataMember(Name = "names", Order = 9)]
            public Names names { get; set; }

            [DataContract]
            public class ReleaseControl
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "public_status", Order = 1)]
                public string publicStatus { get; set; }

                [DataMember(Name = "release_datetime", Order = 2)]
                public long releaseDatetime { get; set; }
            }
            [DataMember(Name = "release_controls", Order = 10)]
            public List<ReleaseControl> releaseControls { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "status", Order = 11)]
            public string status { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "last_update_datetime", Order = 12)]
            public long lastUpdateDatetime { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "scheduled_reflect_datetimes", Order = 13)]
            public List<long> scheduledReflectDatetimes { get; set; }

            // 不足している言語の名称を作成
            public void BuildNames(Languages languages)
            {
                if (names == null)
                {
                    names = new Names();
                }
                names.formalNames = BuildLanguageItems<Names.FormalName>(names.formalNames, languages);
            }

            // 不足している言語の名称を作成、指定方法で名称を変更
            public void UpdateNames(Languages languages, Func<string, string> naming, bool isNameChanged, bool isLaguageChanged)
            {
                if (names == null)
                {
                    names = new Names();
                }
                names.formalNames = BuildLanguageItems<Names.FormalName>(names.formalNames, languages);
                UpdateLanguageItems<Names.FormalName>(names.formalNames, languages, naming, isNameChanged, isLaguageChanged);
            }
        }
    }
}
