﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;
using ContentsUploader.Assistants;

namespace ContentsUploader.Commands
{
    public class DeleteVersionCommand : CommandBase
    {
        //! Nsp 入力
        [CommandLineOption('s', "input", DefaultValue = "", Description = "Nsp of delete-version setting")]
        public override string NspPathOption { get; set; }

        //! ID 入力 ->
        [CommandLineOption("content-meta-id", DefaultValue = "", Description = "Content Meta ID of delete-version setting")]
        public override string ContentMetaIdOption { get; set; }
        //! <-

        public override void Run()
        {
            Run("Delete Version");
        }

        protected override bool RunByContentMetaId(Id64 contentMetaId)
        {
            Log.WriteLine($"Delete Version: {contentMetaId}");

            var d4c = new D4cHelper(Setting.Current);
            return d4c.DeleteVersionByContentMeta(contentMetaId);
        }
    }
}
