﻿using System.Text;
using System.Xml.Linq;
using System.Xml;
using System.IO;

namespace CommandUtility
{
    public class XmlUtility
    {
        public static string MakeXmlText(XElement xml)
        {
            var settings = new XmlWriterSettings()
            {
                Encoding = Encoding.UTF8,
                Indent = true,
                IndentChars = "  "
            };

            using (var stream = new MemoryStream())
            {
                using (var writer = XmlWriter.Create(stream, settings))
                {
                    xml.Save(writer);
                }

                stream.Position = 0;

                using (var reader = new System.IO.StreamReader(stream))
                {
                    return reader.ReadToEnd();
                }
            }
        }

        public static void WriteXml(FileInfo file, XElement xml)
        {
            var xmlText = MakeXmlText(xml);

            using (var writer = file.CreateText())
            {
                writer.WriteLine(xmlText);
            }
        }
    }
}
