﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace CommandUtility
{
    public class ErrorHandling
    {
        public static void Verify(bool expectedCondition, string errorMessage)
        {
            if (!expectedCondition)
            {
                throw new Exception(errorMessage);
            }
        }

        public static void VerifyFileSize(string path, long expectedSize)
        {
            VerifyFileSize(new FileInfo(path), expectedSize);
        }

        public static void VerifyFileSize(FileInfo path, long expectedSize)
        {
            Verify(path.Exists, $"File not found: {path.FullName}");

            Verify(path.Length == expectedSize,
                $"Invalid File Size:" +
                $"    Path: {path.FullName}" +
                $"    Expected: {expectedSize}" +
                $"    Actual: {path.Length}");
        }
    }
}
